/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointPanel;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class AddBreakpointAction
extends AbstractAction {
    private static AddBreakpointDialogManager abdm;

    public AddBreakpointAction() {
        this.putValue("Name", NbBundle.getMessage(AddBreakpointAction.class, (String)"CTL_AddBreakpoint"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        if (debuggerManager.lookup(null, BreakpointType.class).size() == 0) {
            return;
        }
        if (abdm == null) {
            abdm = new AddBreakpointDialogManager();
        }
        abdm.getDialog().setVisible(true);
    }

    static final class AddBreakpointDialogManager
    implements ActionListener,
    PropertyChangeListener {
        private boolean okPressed;
        private Dialog dialog;
        private AddBreakpointPanel panel;
        private DialogDescriptor descriptor;
        private Controller controller;
        private JButton bOk;
        private JButton bCancel;

        AddBreakpointDialogManager() {
        }

        Dialog getDialog() {
            this.dialog = this.createDialog();
            this.okPressed = false;
            this.setValid();
            this.startListening();
            this.panel.addPropertyChangeListener(this);
            return this.dialog;
        }

        private Dialog createDialog() {
            ResourceBundle resourceBundle = NbBundle.getBundle(AddBreakpointAction.class);
            this.panel = new AddBreakpointPanel();
            this.descriptor = new DialogDescriptor((Object)this.panel, resourceBundle.getString("CTL_Breakpoint_Title"), true, (ActionListener)this);
            this.bOk = new JButton(resourceBundle.getString("CTL_Ok"));
            this.descriptor.setOptions((Object[])new JButton[]{this.bOk, this.bCancel = new JButton(resourceBundle.getString("CTL_Cancel"))});
            this.bOk.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Ok"));
            this.bCancel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Cancel"));
            this.descriptor.setClosingOptions(new Object[0]);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
            dialog.pack();
            return dialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.okPressed = this.bOk.equals(actionEvent.getSource());
            Controller controller = this.panel.getController();
            boolean bl = false;
            bl = this.okPressed ? controller.ok() : controller.cancel();
            if (!bl) {
                return;
            }
            this.panel.removePropertyChangeListener(this);
            this.stopListening();
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "type") {
                this.stopListening();
                this.setValid();
                this.startListening();
            } else if (propertyChangeEvent.getPropertyName() == "valid") {
                this.setValid();
            }
        }

        void startListening() {
            this.controller = this.panel.getController();
            if (this.controller == null) {
                return;
            }
            this.controller.addPropertyChangeListener(this);
        }

        void stopListening() {
            if (this.controller == null) {
                return;
            }
            this.controller.removePropertyChangeListener(this);
            this.controller = null;
        }

        void setValid() {
            Controller controller = this.panel.getController();
            if (controller == null) {
                this.bOk.setEnabled(false);
                return;
            }
            this.bOk.setEnabled(controller.isValid());
        }

        public boolean getOKPressed() {
            return this.okPressed;
        }
    }
}

