/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private String viewType;
    private JComponent view;
    private List models = new ArrayList(11);
    private List treeModels;
    private List treeModelFilters;
    private List treeExpansionModels;
    private List nodeModels;
    private List nodeModelFilters;
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private String propertiesHelpID = null;

    ViewModelListener(String string, JComponent jComponent, String string2) {
        this.viewType = string;
        this.view = jComponent;
        this.propertiesHelpID = string2;
        this.setUp();
    }

    ViewModelListener(String string, JComponent jComponent) {
        this.viewType = string;
        this.view = jComponent;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.updateModel();
    }

    synchronized void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.models.clear();
        this.treeModels = null;
        this.treeModelFilters = null;
        this.treeExpansionModels = null;
        this.nodeModels = null;
        this.nodeModelFilters = null;
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateModel();
    }

    private synchronized void updateModel() {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        DebuggerEngine debuggerEngine = debuggerManager.getCurrentEngine();
        DebuggerManager debuggerManager2 = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager) : debuggerManager;
        this.treeModels = debuggerManager2.lookup(this.viewType, TreeModel.class);
        this.treeModelFilters = debuggerManager2.lookup(this.viewType, TreeModelFilter.class);
        this.treeExpansionModels = debuggerManager2.lookup(this.viewType, TreeExpansionModel.class);
        this.nodeModels = debuggerManager2.lookup(this.viewType, NodeModel.class);
        this.nodeModelFilters = debuggerManager2.lookup(this.viewType, NodeModelFilter.class);
        this.tableModels = debuggerManager2.lookup(this.viewType, TableModel.class);
        this.tableModelFilters = debuggerManager2.lookup(this.viewType, TableModelFilter.class);
        this.nodeActionsProviders = debuggerManager2.lookup(this.viewType, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = debuggerManager2.lookup(this.viewType, NodeActionsProviderFilter.class);
        this.columnModels = debuggerManager2.lookup(this.viewType, ColumnModel.class);
        this.mm = debuggerManager2.lookup(this.viewType, Model.class);
        ModelsChangeRefresher modelsChangeRefresher = new ModelsChangeRefresher();
        Customizer[] customizerArray = new Customizer[]{(Customizer)((Object)this.treeModels), (Customizer)((Object)this.treeModelFilters), (Customizer)((Object)this.treeExpansionModels), (Customizer)((Object)this.nodeModels), (Customizer)((Object)this.nodeModelFilters), (Customizer)((Object)this.tableModels), (Customizer)((Object)this.tableModelFilters), (Customizer)((Object)this.nodeActionsProviders), (Customizer)((Object)this.nodeActionsProviderFilters), (Customizer)((Object)this.columnModels), (Customizer)((Object)this.mm)};
        for (int i = 0; i < customizerArray.length; ++i) {
            Customizer customizer = customizerArray[i];
            if (customizer == null) continue;
            customizer.addPropertyChangeListener(modelsChangeRefresher);
            customizer.setObject("load first");
            customizer.setObject("unload last");
        }
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        List list = this.treeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModels));
        }
        list = this.treeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModelFilters));
        }
        list = this.treeExpansionModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeExpansionModels));
        }
        list = this.nodeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModels));
        }
        list = this.nodeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModelFilters));
        }
        list = this.tableModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModels));
        }
        list = this.tableModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModelFilters));
        }
        list = this.nodeActionsProviders;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviders));
        }
        list = this.nodeActionsProviderFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
        }
        list = this.columnModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.columnModels));
        }
        list = this.mm;
        synchronized (list) {
            this.models.add(new ArrayList(this.mm));
        }
        list = Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID);
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)list);
    }

    private class ModelsChangeRefresher
    implements PropertyChangeListener,
    Runnable {
        private RequestProcessor.Task task;

        private ModelsChangeRefresher() {
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.task == null) {
                this.task = new RequestProcessor(ModelsChangeRefresher.class.getName(), 1).create((Runnable)this);
            }
            this.task.schedule(1);
        }

        public void run() {
            ViewModelListener.this.refreshModel();
        }
    }

    private static class EmptyModel
    implements NodeModel {
        public String getDisplayName(Object object) throws UnknownTypeException {
            if (object == "Root") {
                return "Name";
            }
            throw new UnknownTypeException(object);
        }

        public String getIconBase(Object object) throws UnknownTypeException {
            if (object == "Root") {
                return "org/netbeans/modules/debugger/resources/DebuggerTab";
            }
            throw new UnknownTypeException(object);
        }

        public String getShortDescription(Object object) throws UnknownTypeException {
            throw new UnknownTypeException(object);
        }

        public void addModelListener(ModelListener modelListener) {
        }

        public void removeModelListener(ModelListener modelListener) {
        }
    }
}

