/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelsStack {
    private LinkedList<SchemaModel> mSModelsList = new LinkedList();

    public void appendSchemaModel(SchemaModel schemaModel) {
        if (schemaModel != null) {
            if (this.mSModelsList.isEmpty()) {
                this.mSModelsList.addFirst(schemaModel);
            } else {
                SchemaModel schemaModel2 = this.mSModelsList.getFirst();
                if (schemaModel2 == null || !schemaModel.equals(schemaModel2)) {
                    this.mSModelsList.addFirst(schemaModel);
                }
            }
        }
    }

    public void appendSchemaComponent(SchemaComponent schemaComponent) {
        if (schemaComponent != null) {
            SchemaModel schemaModel = schemaComponent.getModel();
            this.appendSchemaModel(schemaModel);
        }
    }

    public void discard() {
        this.mSModelsList.clear();
    }

    public List<SchemaModel> getSchemaModelsList() {
        return this.mSModelsList;
    }

    public static String getEffectiveNamespace(SchemaComponent schemaComponent, SchemaModelsStack schemaModelsStack) {
        SchemaModel schemaModel = schemaComponent.getModel();
        String string = schemaModel.getEffectiveNamespace(schemaComponent);
        if (string != null && string.length() != 0) {
            return string;
        }
        List<SchemaModel> list = schemaModelsStack.getSchemaModelsList();
        for (SchemaModel schemaModel2 : list) {
            string = schemaModel2.getEffectiveNamespace(schemaComponent);
            if (string == null || string.length() == 0) continue;
            return string;
        }
        return null;
    }

    public String toString() {
        return this.mSModelsList.toString();
    }
}

