/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.XPathPseudoComp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSchemaContext
implements XPathSchemaContext {
    private XPathSchemaContext mParentContext;
    private XPathSchemaContext.SchemaCompPair mSchemaCompPair;
    private boolean lastInChain = false;

    public static XPathSchemaContext constructSimpleSchemaContext(XPathSchemaContext xPathSchemaContext, List<SchemaComponent> list) {
        XPathSchemaContext xPathSchemaContext2 = xPathSchemaContext;
        for (SchemaComponent schemaComponent : list) {
            xPathSchemaContext2 = new SimpleSchemaContext(xPathSchemaContext2, schemaComponent);
        }
        return xPathSchemaContext2;
    }

    public SimpleSchemaContext(XPathSchemaContext xPathSchemaContext, XPathSchemaContext.SchemaCompPair schemaCompPair) {
        this.mParentContext = xPathSchemaContext;
        this.mSchemaCompPair = schemaCompPair;
    }

    public SimpleSchemaContext(SchemaComponent schemaComponent) {
        this(null, schemaComponent);
    }

    public SimpleSchemaContext(XPathSchemaContext xPathSchemaContext, SchemaComponent schemaComponent) {
        if (xPathSchemaContext == null) {
            this.mParentContext = null;
            this.mSchemaCompPair = new XPathSchemaContext.SchemaCompPair(schemaComponent, (SchemaCompHolder)null);
        } else {
            this.mParentContext = xPathSchemaContext;
            SchemaCompHolder schemaCompHolder = XPathSchemaContext.Utilities.getSchemaCompHolder(this.mParentContext);
            assert (schemaCompHolder != null);
            this.mSchemaCompPair = new XPathSchemaContext.SchemaCompPair(schemaComponent, schemaCompHolder);
        }
    }

    public SimpleSchemaContext(XPathSchemaContext xPathSchemaContext, XPathPseudoComp xPathPseudoComp) {
        this(xPathSchemaContext, SchemaCompHolder.Factory.construct(xPathPseudoComp));
    }

    public SimpleSchemaContext(XPathSchemaContext xPathSchemaContext, SchemaCompHolder schemaCompHolder) {
        assert (xPathSchemaContext != null);
        this.mParentContext = xPathSchemaContext;
        SchemaCompHolder schemaCompHolder2 = XPathSchemaContext.Utilities.getSchemaCompHolder(this.mParentContext);
        assert (schemaCompHolder2 != null);
        this.mSchemaCompPair = new XPathSchemaContext.SchemaCompPair(schemaCompHolder, schemaCompHolder2);
    }

    @Override
    public XPathSchemaContext getParentContext() {
        return this.mParentContext;
    }

    @Override
    public Set<XPathSchemaContext.SchemaCompPair> getSchemaCompPairs() {
        return Collections.singleton(this.mSchemaCompPair);
    }

    @Override
    public Set<XPathSchemaContext.SchemaCompPair> getUsedSchemaCompPairs() {
        return this.getSchemaCompPairs();
    }

    @Override
    public void setUsedSchemaCompH(Set<SchemaCompHolder> set) {
    }

    @Override
    public String toStringWithoutParent() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mSchemaCompPair != null) {
            SchemaCompHolder schemaCompHolder = this.mSchemaCompPair.getCompHolder();
            XPathSchemaContext.SchemaCompPair.appendCompName(stringBuilder, schemaCompHolder);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mParentContext != null) {
            stringBuilder.append(this.mParentContext.toString());
        }
        stringBuilder.append("/");
        if (this.mSchemaCompPair != null) {
            stringBuilder.append(this.toStringWithoutParent());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleSchemaContext) {
            SchemaCompHolder schemaCompHolder;
            SimpleSchemaContext simpleSchemaContext = (SimpleSchemaContext)object;
            SchemaCompHolder schemaCompHolder2 = this.mSchemaCompPair.getCompHolder();
            return schemaCompHolder2.equals(schemaCompHolder = simpleSchemaContext.mSchemaCompPair.getCompHolder());
        }
        if (object instanceof XPathSchemaContext) {
            return XPathSchemaContext.Utilities.equals(this, (XPathSchemaContext)object);
        }
        return false;
    }

    @Override
    public boolean equalsChain(XPathSchemaContext xPathSchemaContext) {
        if (this.equals(xPathSchemaContext)) {
            boolean bl;
            XPathSchemaContext xPathSchemaContext2 = this.mParentContext;
            XPathSchemaContext xPathSchemaContext3 = xPathSchemaContext.getParentContext();
            return !(xPathSchemaContext2 != null && xPathSchemaContext3 != null ? !(bl = xPathSchemaContext2.equalsChain(xPathSchemaContext3)) : xPathSchemaContext2 == null && xPathSchemaContext3 != null || xPathSchemaContext2 != null && xPathSchemaContext3 == null);
        }
        return false;
    }

    @Override
    public boolean isLastInChain() {
        return this.lastInChain;
    }

    @Override
    public void setLastInChain(boolean bl) {
        this.lastInChain = bl;
    }
}

