/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.web.ui.dt.component.vforms;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupHolder;
import com.sun.rave.designtime.ext.componentgroup.impl.ColorWrapperImpl;
import com.sun.rave.designtime.ext.componentgroup.util.ComponentGroupHelper;
import com.sun.rave.web.ui.component.Form;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.visualweb.web.ui.dt.component.FormDesignInfo;
import org.netbeans.modules.visualweb.web.ui.dt.component.vforms.EditVirtualFormsCustomizer;
import org.netbeans.modules.visualweb.web.ui.dt.component.vforms.HomogonousCellRenderer;
import org.netbeans.modules.visualweb.web.ui.dt.component.vforms.TextFieldCellEditor;
import org.netbeans.modules.visualweb.web.ui.dt.component.vforms.VirtualFormsHelper;

public class EditVirtualFormsCustomizerPanel
extends JPanel {
    protected EditVirtualFormsCustomizer customizer;
    protected DesignBean[] beans;
    private DesignBean formBean;
    private List inputBeans = new ArrayList();
    private List actionBeans = new ArrayList();
    private List vformsList = new ArrayList();
    private Map colorMap = new HashMap();
    private FormsTableModel vformsTableModel = new FormsTableModel();
    private boolean canParticipate = true;
    private boolean canSubmit = true;
    private static final String YES = ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("yes");
    private static final String NO = ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("no");
    private static final String SOME_PARTICIPATE = ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("someParticipate");
    private static final String SOME_SUBMIT = ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("someSubmit");
    private static final String[] NO_ONLY = new String[]{NO};
    private static final String[] YES_NO = new String[]{YES, NO};
    private static final String[] YES_NO_SOME_PARTICIPATE = new String[]{YES, NO, SOME_PARTICIPATE};
    private static final String[] YES_NO_SOME_SUBMIT = new String[]{YES, NO, SOME_SUBMIT};
    private JButton btnDelete;
    private JButton btnNew;
    private JScrollPane jScrollPane1;
    private JLabel tableLabel;
    private JTable vformsTable;

    public Result applyChanges() {
        Form.VirtualFormDescriptor[] virtualFormDescriptorArray = this.vformsList.toArray(new Form.VirtualFormDescriptor[this.vformsList.size()]);
        String string = Form.generateVirtualFormsConfig((Form.VirtualFormDescriptor[])virtualFormDescriptorArray);
        DesignProperty designProperty = this.formBean.getProperty("virtualFormsConfig");
        designProperty.setValue((Object)string);
        DesignContext designContext = this.customizer.getDesignBean().getDesignContext();
        for (int i = 0; virtualFormDescriptorArray != null && i < virtualFormDescriptorArray.length; ++i) {
            String string2 = virtualFormDescriptorArray[i].getName();
            String string3 = this.getColorKey(string2);
            Color color = (Color)this.colorMap.get(string3);
            if (color == null) continue;
            designContext.setContextData(string3, (Object)new ColorWrapperImpl(color));
        }
        this.customizer.setModified(false);
        return null;
    }

    public EditVirtualFormsCustomizerPanel(EditVirtualFormsCustomizer editVirtualFormsCustomizer) {
        this.customizer = editVirtualFormsCustomizer;
        this.beans = editVirtualFormsCustomizer.getDesignBeans();
        this.canParticipate = this.initCanParticipate();
        this.canSubmit = this.initCanSubmit();
        this.initComponents();
        this.readVFormInfo();
    }

    public EditVirtualFormsCustomizerPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.tableLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.vformsTable = new JTable();
        this.vformsTable.setSelectionMode(0);
        JTextField jTextField = new JTextField();
        TextFieldCellEditor textFieldCellEditor = new TextFieldCellEditor(this.vformsTable, jTextField);
        this.vformsTable.setDefaultEditor(String.class, textFieldCellEditor);
        ((DefaultCellEditor)this.vformsTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.vformsTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        this.vformsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.btnNew = new JButton();
        this.btnDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(550, 250));
        this.getAccessibleContext().setAccessibleName("Edit Virtual Forms dialog box");
        this.getAccessibleContext().setAccessibleDescription("Use this table to view and edit properties of the virutal forms defined on this page.");
        this.tableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("labelMnemonic").charAt(0));
        this.tableLabel.setLabelFor(this.vformsTable);
        this.tableLabel.setText(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("editLabel"), this.getSelectedComponentsDisplayText()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.tableLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("tableLabelAccessibleName"));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("editTableLabelAccessibleDescription"));
        this.jScrollPane1.setBackground(SystemColor.window);
        this.jScrollPane1.setViewportView(this.vformsTable);
        this.vformsTable.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.vformsTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("editVformsTableAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("editVformsTableAccessibleDescription"));
        this.btnNew.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("newButtonMnemonic").charAt(0));
        this.btnNew.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("New"));
        this.btnNew.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("NewVf"));
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditVirtualFormsCustomizerPanel.this.btnNewActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.btnNew, gridBagConstraints);
        this.btnNew.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("btnNewAccessibleName"));
        this.btnNew.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("btnNewAccessibleDescription"));
        this.btnDelete.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("deleteButtonMnemonic").charAt(0));
        this.btnDelete.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("Delete"));
        this.btnDelete.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("DeleteVf"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditVirtualFormsCustomizerPanel.this.btnDeleteActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.btnDelete, gridBagConstraints);
        this.btnDelete.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("btnDeleteAccessibleName"));
        this.btnDelete.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("btnDeleteAccessibleDescription"));
    }

    private void btnDeleteActionPerformed(ActionEvent actionEvent) {
        int n = this.vformsTable.getSelectedRow();
        if (n > -1 && n < this.vformsList.size()) {
            Form.VirtualFormDescriptor virtualFormDescriptor = (Form.VirtualFormDescriptor)this.vformsList.get(n);
            String string = ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("confirmDeleteTitle");
            String string2 = MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("confirmDeleteMessage"), virtualFormDescriptor.getName());
            if (JOptionPane.showConfirmDialog(this, string2, string, 0) == 0) {
                this.vformsList.remove(n);
                this.vformsTableModel.fireTableDataChanged();
                if (this.vformsList.size() <= n) {
                    --n;
                }
                if (n >= 0) {
                    this.vformsTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        }
    }

    private void btnNewActionPerformed(ActionEvent actionEvent) {
        String string = VirtualFormsHelper.getNewVirtualFormName(this.vformsList);
        Form.VirtualFormDescriptor virtualFormDescriptor = new Form.VirtualFormDescriptor(string);
        this.vformsList.add(virtualFormDescriptor);
        this.vformsTableModel.fireTableDataChanged();
        this.vformsTable.getSelectionModel().setSelectionInterval(this.vformsList.size() - 1, this.vformsList.size() - 1);
    }

    private boolean initCanParticipate() {
        for (int i = 0; i < this.beans.length; ++i) {
            if (!(this.beans[i].getInstance() instanceof EditableValueHolder)) continue;
            return true;
        }
        return false;
    }

    private String getParticipates(Form.VirtualFormDescriptor virtualFormDescriptor) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.beans.length; ++i) {
            String string;
            Object object = this.beans[i].getInstance();
            boolean bl3 = object instanceof EditableValueHolder;
            if (!bl3 || (string = FormDesignInfo.getFullyQualifiedId(this.beans[i])) == null) continue;
            if (virtualFormDescriptor.hasParticipant(string)) {
                bl = true;
                if (!bl2) continue;
                return SOME_PARTICIPATE;
            }
            bl2 = true;
            if (!bl) continue;
            return SOME_PARTICIPATE;
        }
        if (bl) {
            return YES;
        }
        return NO;
    }

    private void setParticipates(Form.VirtualFormDescriptor virtualFormDescriptor, boolean bl) {
        int n;
        String[] stringArray = virtualFormDescriptor.getParticipatingIds();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < this.beans.length; ++n) {
            boolean bl2;
            Object object3;
            String string;
            Object object2 = this.beans[n].getInstance();
            if (!(object2 instanceof UIComponent) || (string = FormDesignInfo.getFullyQualifiedId(this.beans[n])) == null) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object3 : arrayList) {
                if (!Form.fullyQualifiedIdMatchesPattern((String)string, (String)object3)) continue;
                arrayList2.add((String)object3);
            }
            boolean bl3 = bl2 = arrayList2.size() > 0;
            if (bl && !bl2 && object2 instanceof EditableValueHolder) {
                object3 = string;
                if (((String)object3).startsWith(String.valueOf(':')) && ((String)object3).length() > 1) {
                    object3 = ((String)object3).substring(1, ((String)object3).length());
                }
                arrayList.add(object3);
                this.customizer.setModified(true);
                continue;
            }
            if (bl || !bl2) continue;
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                Object e = object3.next();
                arrayList.remove(e);
                this.customizer.setModified(true);
            }
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        virtualFormDescriptor.setParticipatingIds(stringArray);
    }

    private boolean initCanSubmit() {
        for (int i = 0; i < this.beans.length; ++i) {
            if (!(this.beans[i].getInstance() instanceof ActionSource) && !(this.beans[i].getInstance() instanceof EditableValueHolder)) continue;
            return true;
        }
        return false;
    }

    private String getSubmits(Form.VirtualFormDescriptor virtualFormDescriptor) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.beans.length; ++i) {
            String string = FormDesignInfo.getFullyQualifiedId(this.beans[i]);
            if (string == null) continue;
            if (virtualFormDescriptor.isSubmittedBy(string)) {
                bl = true;
                if (!bl2) continue;
                return SOME_SUBMIT;
            }
            bl2 = true;
            if (!bl) continue;
            return SOME_SUBMIT;
        }
        if (bl) {
            return YES;
        }
        return NO;
    }

    private void setSubmits(Form.VirtualFormDescriptor virtualFormDescriptor, boolean bl) {
        int n;
        String[] stringArray = virtualFormDescriptor.getSubmittingIds();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < this.beans.length; ++n) {
            boolean bl2;
            Object object3;
            String string;
            Object object2 = this.beans[n].getInstance();
            if (!(object2 instanceof UIComponent) || (string = FormDesignInfo.getFullyQualifiedId(this.beans[n])) == null) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object3 : arrayList) {
                if (!Form.fullyQualifiedIdMatchesPattern((String)string, (String)object3)) continue;
                arrayList2.add((String)object3);
            }
            boolean bl3 = bl2 = arrayList2.size() > 0;
            if (bl && !bl2 && (object2 instanceof ActionSource || object2 instanceof EditableValueHolder)) {
                object3 = string;
                if (((String)object3).startsWith(String.valueOf(':')) && ((String)object3).length() > 1) {
                    object3 = ((String)object3).substring(1, ((String)object3).length());
                }
                arrayList.add(object3);
                this.customizer.setModified(true);
                continue;
            }
            if (bl || !bl2) continue;
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                Object e = object3.next();
                arrayList.remove(e);
                this.customizer.setModified(true);
            }
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        virtualFormDescriptor.setSubmittingIds(stringArray);
    }

    private void readVFormInfo() {
        Object object;
        this.formBean = VirtualFormsHelper.findFormBean(this.beans);
        DesignContext designContext = this.formBean.getDesignContext();
        ComponentGroupHolder[] componentGroupHolderArray = ComponentGroupHelper.getComponentGroupHolders((DesignContext)designContext);
        ComponentGroupHelper.populateColorMap((DesignContext)designContext, (ComponentGroupHolder[])componentGroupHolderArray, (Map)this.colorMap);
        Form form = (Form)this.formBean.getInstance();
        Form.VirtualFormDescriptor[] virtualFormDescriptorArray = form.getVirtualForms();
        for (int i = 0; virtualFormDescriptorArray != null && i < virtualFormDescriptorArray.length; ++i) {
            object = virtualFormDescriptorArray[i].getName();
            Form.VirtualFormDescriptor virtualFormDescriptor = new Form.VirtualFormDescriptor((String)object);
            virtualFormDescriptor.setParticipatingIds(virtualFormDescriptorArray[i].getParticipatingIds());
            virtualFormDescriptor.setSubmittingIds(virtualFormDescriptorArray[i].getSubmittingIds());
            this.vformsList.add(virtualFormDescriptor);
        }
        this.vformsTable.setModel(this.vformsTableModel);
        this.vformsTable.setSelectionMode(0);
        TableColumn tableColumn = this.vformsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new ColorCellRenderer());
        tableColumn.setCellEditor(new DefaultCellEditor(new ColorComboBox()));
        ((DefaultCellEditor)tableColumn.getCellEditor()).setClickCountToStart(2);
        object = this.vformsTable.getColumnModel().getColumn(2);
        ((TableColumn)object).setCellEditor(new DefaultCellEditor(new PSComboBox(true)));
        ((DefaultCellEditor)((TableColumn)object).getCellEditor()).setClickCountToStart(2);
        object = this.vformsTable.getColumnModel().getColumn(3);
        ((TableColumn)object).setCellEditor(new DefaultCellEditor(new PSComboBox(false)));
        ((DefaultCellEditor)((TableColumn)object).getCellEditor()).setClickCountToStart(2);
        if (this.vformsTableModel.getRowCount() > 0) {
            this.vformsTable.changeSelection(0, 0, false, false);
        }
    }

    private String[] getOptions(boolean bl) {
        if (bl) {
            boolean bl2 = false;
            for (int i = 0; i < this.beans.length; ++i) {
                Object object = this.beans[i].getInstance();
                if (!(object instanceof EditableValueHolder)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return NO_ONLY;
            }
        }
        return YES_NO;
    }

    private String getSelectedComponentsDisplayText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            stringBuffer.append(this.beans[i].getInstanceName());
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    private String getColorKey(String string) {
        String string2 = this.formBean.getInstanceName();
        String string3 = string2 + "." + string;
        return ComponentGroupHelper.getComponentGroupColorKey((String)FormDesignInfo.VIRTUAL_FORM_HOLDER_NAME, (String)string3);
    }

    class ColorListRenderer
    extends DefaultListCellRenderer {
        ColorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Color color = (Color)object;
            this.setIcon(new ColorIcon(color));
            this.setText(null);
            return this;
        }
    }

    class PSComboBox
    extends JComboBox {
        public PSComboBox(boolean bl) {
            this.setOptions(EditVirtualFormsCustomizerPanel.this.getOptions(bl));
        }

        private void setOptions(String[] stringArray) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultComboBoxModel.addElement(stringArray[i]);
            }
            this.setModel(defaultComboBoxModel);
        }
    }

    class ColorComboBox
    extends JComboBox {
        public ColorComboBox() {
            DefaultComboBoxModel<Color> defaultComboBoxModel = new DefaultComboBoxModel<Color>();
            for (int i = 0; i < ComponentGroupHelper.DEFAULT_COLOR_SET.length; ++i) {
                Color color = ComponentGroupHelper.DEFAULT_COLOR_SET[i];
                defaultComboBoxModel.addElement(color);
            }
            this.setModel(defaultComboBoxModel);
            this.setRenderer(new ColorListRenderer());
            this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("colorComboAccessibleName"));
            this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("colorComboAccessibleDescription"));
        }
    }

    class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 8, 8);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");
        Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("TextField.selectionForeground");
        Color BACKGROUND = UIManager.getDefaults().getColor("TextField.background");
        Color FOREGROUND = UIManager.getDefaults().getColor("TextField.foreground");

        ColorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                component.setBackground(this.SELECTION_BACKGROUND);
                component.setForeground(this.SELECTION_FOREGROUND);
            } else {
                component.setBackground(this.BACKGROUND);
                component.setForeground(this.FOREGROUND);
            }
            Color color = (Color)object;
            this.setIcon(new ColorIcon(color));
            this.setText(null);
            return this;
        }
    }

    class FormsTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return EditVirtualFormsCustomizerPanel.this.vformsList.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("colorHeader");
                }
                case 1: {
                    return ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("nameHeader");
                }
                case 2: {
                    return ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("participateHeader");
                }
                case 3: {
                    return ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/vforms/Bundle").getString("submitHeader");
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Color.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            Form.VirtualFormDescriptor virtualFormDescriptor = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(n);
            if (virtualFormDescriptor != null) {
                switch (n2) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return EditVirtualFormsCustomizerPanel.this.canParticipate;
                    }
                    case 3: {
                        return EditVirtualFormsCustomizerPanel.this.canSubmit;
                    }
                }
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Form.VirtualFormDescriptor virtualFormDescriptor = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(n);
            if (virtualFormDescriptor != null) {
                switch (n2) {
                    case 0: {
                        String string = virtualFormDescriptor.getName();
                        String string2 = EditVirtualFormsCustomizerPanel.this.getColorKey(string);
                        return ComponentGroupHelper.getMappedColor((String)string2, (Map)EditVirtualFormsCustomizerPanel.this.colorMap);
                    }
                    case 1: {
                        return virtualFormDescriptor.getName();
                    }
                    case 2: {
                        return EditVirtualFormsCustomizerPanel.this.getParticipates(virtualFormDescriptor);
                    }
                    case 3: {
                        return EditVirtualFormsCustomizerPanel.this.getSubmits(virtualFormDescriptor);
                    }
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            Form.VirtualFormDescriptor virtualFormDescriptor = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(n);
            if (virtualFormDescriptor != null) {
                switch (n2) {
                    case 0: {
                        String string = virtualFormDescriptor.getName();
                        String string2 = EditVirtualFormsCustomizerPanel.this.getColorKey(string);
                        EditVirtualFormsCustomizerPanel.this.colorMap.put(string2, object);
                        EditVirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                    case 1: {
                        String string = object.toString();
                        string = string.trim();
                        string = string.replaceAll("\\|", "_");
                        string = string.replaceAll(",", "_");
                        if (string.length() < 1) {
                            string = VirtualFormsHelper.getNewVirtualFormName(EditVirtualFormsCustomizerPanel.this.vformsList);
                        }
                        String string3 = virtualFormDescriptor.getName();
                        String string4 = EditVirtualFormsCustomizerPanel.this.getColorKey(string3);
                        Color color = (Color)EditVirtualFormsCustomizerPanel.this.colorMap.get(string4);
                        EditVirtualFormsCustomizerPanel.this.colorMap.remove(string4);
                        virtualFormDescriptor.setName(string);
                        string4 = EditVirtualFormsCustomizerPanel.this.getColorKey(string);
                        EditVirtualFormsCustomizerPanel.this.colorMap.put(string4, color);
                        EditVirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                    case 2: {
                        String string = (String)object;
                        boolean bl = YES.equals(string);
                        EditVirtualFormsCustomizerPanel.this.setParticipates(virtualFormDescriptor, bl);
                        return;
                    }
                    case 3: {
                        String string = (String)object;
                        boolean bl = YES.equals(string);
                        EditVirtualFormsCustomizerPanel.this.setSubmits(virtualFormDescriptor, bl);
                        if (bl) {
                            for (Form.VirtualFormDescriptor virtualFormDescriptor2 : EditVirtualFormsCustomizerPanel.this.vformsList) {
                                if (virtualFormDescriptor2.getName().equals(virtualFormDescriptor.getName())) continue;
                                EditVirtualFormsCustomizerPanel.this.setSubmits(virtualFormDescriptor2, false);
                            }
                            this.fireTableDataChanged();
                        }
                        return;
                    }
                }
            }
        }
    }
}

