/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibManifest;
import org.netbeans.modules.visualweb.complib.ComplibPaletteItemDataObject;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.netbeans.modules.visualweb.palette.api.PaletteItemInfoCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PaletteUtil {
    private static final Palette J2EE_1_4 = new Palette("CreatorDesignerPalette");
    private static final Palette JAVA_EE_5 = new Palette("CreatorDesignerPalette5");
    private static final List<Palette> PALETTES_FOR_J2EE_1_4;
    private static final List<Palette> PALETTES_FOR_JAVA_EE_5;
    private static final String CREATED_BY_COMPLIB = "created-by-complib";
    private static final String POSITION = "position";

    PaletteUtil() {
    }

    public static List<Palette> getPaletteRoots(Complib complib) {
        return complib.getCompLibManifest().getEeSpecVersion() == ComplibManifest.EeSpecVersion.J2EE_1_4 ? PALETTES_FOR_J2EE_1_4 : PALETTES_FOR_JAVA_EE_5;
    }

    public static List<Category> getAllCategories() {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        for (Palette palette : PALETTES_FOR_J2EE_1_4) {
            arrayList.addAll(palette.getChildren());
        }
        return arrayList;
    }

    public static boolean isCreatedByComplib(FileObject fileObject) {
        return fileObject.getAttribute(CREATED_BY_COMPLIB) != null;
    }

    static {
        PALETTES_FOR_JAVA_EE_5 = new ArrayList<Palette>(1);
        PALETTES_FOR_JAVA_EE_5.add(JAVA_EE_5);
        PALETTES_FOR_J2EE_1_4 = new ArrayList<Palette>(PALETTES_FOR_JAVA_EE_5);
        PALETTES_FOR_J2EE_1_4.add(J2EE_1_4);
    }

    static class Item
    extends AbstractPaletteNode {
        private static final Complib.Identifier INVALID_ID = new Complib.Identifier("urn:invalid-complib-id", "1.0.0");
        private String className;
        private Complib complib;

        private Item(FileObject fileObject, String string, Complib complib) {
            super(fileObject);
            this.className = string;
            this.complib = complib;
        }

        public String getClassName() {
            return this.className;
        }

        public Complib.Identifier getComplibId() {
            if (this.complib == null) {
                return INVALID_ID;
            }
            return this.complib.getIdentifier();
        }

        public Complib getComplib() {
            return this.complib;
        }

        public String toString() {
            return this.getClassName() + "{" + super.toString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Category
    extends AbstractPaletteNode {
        private static WeakHashMap<FileObject, Item> foMap = new WeakHashMap();

        private Category(FileObject fileObject) {
            super(fileObject);
        }

        public List<Item> getChildren() {
            ArrayList<Item> arrayList = new ArrayList<Item>();
            for (FileObject fileObject : this.getFileObject().getChildren()) {
                Item item = foMap.get(fileObject);
                if (item == null) {
                    try {
                        item = this.createItem(fileObject);
                    }
                    catch (IOException iOException) {
                        IdeUtil.logWarning("Skipping child item FileObject", iOException);
                        continue;
                    }
                    foMap.put(fileObject, item);
                }
                arrayList.add(item);
            }
            return arrayList;
        }

        private Item createItem(FileObject fileObject) throws IOException {
            Item item;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject instanceof ComplibPaletteItemDataObject) {
                ComplibPaletteItemDataObject complibPaletteItemDataObject = (ComplibPaletteItemDataObject)dataObject;
                item = new Item(fileObject, complibPaletteItemDataObject.getClassName(), complibPaletteItemDataObject.getComplib());
            } else {
                dataObject.getNodeDelegate().getDisplayName();
                PaletteItemInfoCookie paletteItemInfoCookie = (PaletteItemInfoCookie)dataObject.getCookie(PaletteItemInfoCookie.class);
                if (paletteItemInfoCookie == null) {
                    throw new IOException("PaletteItemInfoCookie is null");
                }
                item = new Item(fileObject, paletteItemInfoCookie.getClassName(), null);
            }
            return item;
        }

        public void createItem(ComplibServiceProvider.ComponentInfo componentInfo) throws IOException {
            final String string = componentInfo.getClassName();
            Complib complib = componentInfo.getComplib();
            final Complib.Identifier identifier = complib.getIdentifier();
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    try {
                        ComplibPaletteItemDataObject.createFile(Category.this.getFileObject(), string, identifier.getNamespaceUriString(), identifier.getVersionString());
                    }
                    catch (IOException iOException) {
                        IdeUtil.logWarning("Unable to create complib palette item file", iOException);
                        throw iOException;
                    }
                }
            });
        }

        public String getName() {
            return this.getFileObject().getNameExt();
        }

        @Override
        public String toString() {
            return this.getName() + "{" + super.toString() + "}";
        }

        public boolean isCreatedByComplib() {
            return PaletteUtil.isCreatedByComplib(this.getFileObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Palette
    extends AbstractPaletteNode {
        private static WeakHashMap<FileObject, Category> foMap = new WeakHashMap();

        private Palette(String string) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            this.initFileObject(fileObject);
        }

        public List<Category> getChildren() {
            ArrayList<Category> arrayList = new ArrayList<Category>();
            for (FileObject fileObject : this.getFileObject().getChildren()) {
                Category category = foMap.get(fileObject);
                if (category == null) {
                    category = new Category(fileObject);
                    foMap.put(fileObject, category);
                }
                arrayList.add(category);
            }
            return arrayList;
        }

        public Category getOrCreateCategory(String string) throws ComplibException {
            FileObject fileObject;
            try {
                FileObject fileObject2 = this.getFileObject();
                FileObject fileObject3 = fileObject2.getFileObject(string);
                if (fileObject3 == null) {
                    fileObject = fileObject2.createFolder(string);
                    fileObject.setAttribute(PaletteUtil.POSITION, (Object)0);
                    fileObject.setAttribute(PaletteUtil.CREATED_BY_COMPLIB, (Object)Boolean.TRUE);
                    try {
                        this.makeFileObjectFirst(fileObject);
                    }
                    catch (IOException iOException) {
                        IdeUtil.logWarning(iOException);
                    }
                } else {
                    if (!fileObject3.isFolder()) {
                        throw new ComplibException("Unable to create category folder, found plain file: " + fileObject3);
                    }
                    fileObject = fileObject3;
                }
            }
            catch (IOException iOException) {
                throw new ComplibException("Unable to create category", (Throwable)iOException);
            }
            return new Category(fileObject);
        }

        private void makeFileObjectFirst(FileObject fileObject) throws IOException {
            DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)this.getFileObject());
            DataObject[] dataObjectArray = dataFolder.getChildren();
            List<DataObject> list = Arrays.asList(dataObjectArray);
            LinkedList<DataObject> linkedList = new LinkedList<DataObject>(list);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            linkedList.remove(dataObject);
            linkedList.add(0, dataObject);
            dataObjectArray = linkedList.toArray(new DataObject[linkedList.size()]);
            dataFolder.setOrder(dataObjectArray);
        }
    }

    private static abstract class AbstractPaletteNode {
        private FileObject fileObject;

        private AbstractPaletteNode() {
        }

        private AbstractPaletteNode(FileObject fileObject) {
            this.initFileObject(fileObject);
        }

        public void initFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public void remove() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fileObject);
                Node node = dataObject.getNodeDelegate();
                node.destroy();
            }
            catch (IOException iOException) {
                IdeUtil.logWarning("Unable to remove FileObject '" + this.fileObject.getNameExt() + "'", iOException);
            }
        }

        protected FileObject getFileObject() {
            return this.fileObject;
        }

        public String toString() {
            return this.getFileObject().getPath();
        }
    }
}

