/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibPackage;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.XmlException;
import org.netbeans.modules.visualweb.complib.XmlUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scope {
    private static final String PATH_PROJECT_SCOPE_COMPLIB = "complibs";
    private static final String LIBRARY_INDEX_FILENAME = "index.xml";
    private static final String DIRECTORY_ELEMENT = "directory";
    private static final String DIRECTORY_NAME_ATTR = "name";
    private static final String VALID_DIRECTORY_LIST = "valid-directory-list";
    private static WeakHashMap<File, Scope> registry = new WeakHashMap();
    private final File installHome;
    private HashSet<String> directorySet = new HashSet();
    private HashSet<ExtensionComplib> complibSet = new HashSet();

    private Scope(File file) {
        this.installHome = file;
        this.loadComplibs();
    }

    static Scope createScope(File file) {
        return new Scope(file);
    }

    public static Scope getScopeForProject(Project project) throws IOException {
        File file = Scope.getProjectInstallHome(project);
        Scope scope = registry.get(file);
        if (scope == null) {
            scope = new Scope(file);
            registry.put(file, scope);
        }
        return scope;
    }

    public static void destroyScopeForProject(Project project) throws IOException {
        File file = Scope.getProjectInstallHome(project);
        registry.remove(file);
    }

    private static File getProjectInstallHome(Project project) throws IOException {
        File file = IdeUtil.getProjectLibraryDirectory(project);
        File file2 = new File(file, PATH_PROJECT_SCOPE_COMPLIB);
        return file2;
    }

    private void loadComplibs() {
        Set<String> set = this.readDirectoryIndex();
        FileObject fileObject = FileUtil.toFileObject((File)this.installHome);
        if (fileObject == null) {
            return;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            File file = FileUtil.toFile((FileObject)fileObject2);
            String string = file.getName();
            if (LIBRARY_INDEX_FILENAME.equals(string)) continue;
            if (set.contains(string)) {
                ExtensionComplib extensionComplib;
                try {
                    extensionComplib = new ExtensionComplib(file);
                }
                catch (Exception exception) {
                    IdeUtil.logWarning(exception);
                    set.remove(string);
                    try {
                        this.persistDirectoryIndex();
                    }
                    catch (Exception exception2) {}
                    continue;
                }
                this.complibSet.add(extensionComplib);
                continue;
            }
            try {
                fileObject2.delete();
            }
            catch (IOException iOException) {
                IdeUtil.logWarning(iOException);
            }
        }
    }

    public long getTimeStamp(ExtensionComplib extensionComplib) {
        return extensionComplib.getDirectory().lastModified();
    }

    private File ensureInstallHome() throws FileNotFoundException {
        if (!this.installHome.exists() && !this.installHome.mkdirs()) {
            throw new FileNotFoundException(this.installHome.getAbsolutePath());
        }
        return this.installHome;
    }

    ExtensionComplib installComplibPackage(ComplibPackage complibPackage) throws IOException, ComplibException {
        File file = complibPackage.getPackageFile();
        String string = file.getName();
        String string2 = IdeUtil.removeWhiteSpace(IdeUtil.removeExtension(string));
        File file2 = IdeUtil.findUniqueFile(this.ensureInstallHome(), string2, "");
        IdeUtil.unzip(file, file2);
        return this.createComplib(file2);
    }

    ExtensionComplib installComplib(ExtensionComplib extensionComplib) throws IOException, ComplibException {
        String string = extensionComplib.getDirectoryBaseName();
        File file = IdeUtil.findUniqueFile(this.ensureInstallHome(), string, "");
        IdeUtil.copyFileRecursive(extensionComplib.getDirectory(), file);
        return this.createComplib(file);
    }

    private ExtensionComplib createComplib(File file) throws ComplibException, IOException {
        ExtensionComplib extensionComplib = new ExtensionComplib(file);
        this.complibSet.add(extensionComplib);
        this.directorySet.add(extensionComplib.getDirectoryBaseName());
        this.persistDirectoryIndex();
        return extensionComplib;
    }

    static void copyFile(File file, File file2) throws IOException {
        File file3 = null;
        file3 = file2.isDirectory() ? new File(file2, file.getName()) : file2;
        if (file.isDirectory()) {
            file3.mkdir();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Scope.copyFile(fileArray[i], file3);
            }
        } else {
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                while ((n = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
        }
    }

    public void remove(ExtensionComplib extensionComplib) {
        this.directorySet.remove(extensionComplib.getDirectoryBaseName());
        this.complibSet.remove(extensionComplib);
        try {
            this.persistDirectoryIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = extensionComplib.getDirectory();
        Scope.recursiveDelete(file);
    }

    private static boolean recursiveDelete(File file) {
        if (file.getParentFile() == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Scope.recursiveDelete(fileArray[i]);
            }
        }
        return file.delete();
    }

    public ExtensionComplib getExistingComplib(Complib complib) {
        Complib.Identifier identifier = complib.getIdentifier();
        for (ExtensionComplib extensionComplib : this.complibSet) {
            if (!extensionComplib.getIdentifier().equals(identifier)) continue;
            return extensionComplib;
        }
        return null;
    }

    boolean contains(ExtensionComplib extensionComplib) {
        return this.getExistingComplib(extensionComplib) != null;
    }

    public long getLastModified() {
        return this.getIndexFile().lastModified();
    }

    public Set<ExtensionComplib> getComplibs() {
        return this.complibSet;
    }

    public String toString() {
        return "{installHome='" + this.installHome + "', directorySet=" + this.directorySet + ", complibSet=" + this.complibSet + "}";
    }

    private File getIndexFile() {
        return new File(this.installHome, LIBRARY_INDEX_FILENAME);
    }

    private Set<String> readDirectoryIndex() {
        Document document;
        File file = this.getIndexFile();
        if (!file.exists()) {
            return this.directorySet;
        }
        XmlUtil xmlUtil = new XmlUtil();
        try {
            document = xmlUtil.read(file);
        }
        catch (XmlException xmlException) {
            return this.directorySet;
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(DIRECTORY_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(DIRECTORY_NAME_ATTR);
            this.directorySet.add(string);
        }
        return this.directorySet;
    }

    private void persistDirectoryIndex() throws IOException {
        File file = this.getIndexFile();
        XmlUtil xmlUtil = new XmlUtil();
        Document document = xmlUtil.createDocument();
        Comment comment = document.createComment(" Directory list containing valid component libraries which is a workaround for Win32 file deletion problems.");
        document.appendChild(comment);
        Element element = document.createElement(VALID_DIRECTORY_LIST);
        document.appendChild(element);
        for (String string : this.directorySet) {
            Element element2 = document.createElement(DIRECTORY_ELEMENT);
            element2.setAttribute(DIRECTORY_NAME_ATTR, string);
            element.appendChild(element2);
        }
        xmlUtil.write(file);
    }
}

