/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.SharedComplib;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SharedComplibPanel
extends JPanel {
    private static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
    private List<String> postedMessages;
    private JButton addJButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel messageJLabel;
    private JList optionsJList;
    private JButton refreshJButton;
    private JButton removeJButton;
    private JList sharedComplibJList;

    public SharedComplibPanel() {
        this.initComponents();
        this.clearStatusMessage();
        this.initOptionsJList();
        this.updateSharedComplibList();
    }

    private void clearStatusMessage() {
        this.postedMessages = new ArrayList<String>();
        this.messageJLabel.setText(" ");
    }

    private void addErrorMessage(String string) {
        if (this.postedMessages.size() == 0) {
            this.messageJLabel.setText("Error: " + string);
            this.postedMessages.add(string);
        } else {
            this.messageJLabel.setText("First Error: " + this.postedMessages.get(0));
        }
    }

    private void initOptionsJList() {
        List<Project> list = csp.getEligibleSharedComplibProjects();
        final ProjectWrapper[] projectWrapperArray = new ProjectWrapper[list.size()];
        int n = 0;
        for (Project project : list) {
            projectWrapperArray[n++] = new ProjectWrapper(project);
        }
        this.optionsJList.setModel(new AbstractListModel(){

            public int getSize() {
                return projectWrapperArray.length;
            }

            public Object getElementAt(int n) {
                return projectWrapperArray[n];
            }
        });
        if (projectWrapperArray.length > 0) {
            this.optionsJList.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.messageJLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.optionsJList = new JList();
        this.addJButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sharedComplibJList = new JList();
        this.removeJButton = new JButton();
        this.refreshJButton = new JButton();
        this.messageJLabel.setForeground(Color.red);
        this.messageJLabel.setText("Status message goes here");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Select an Open Shared Component Library Project*:");
        this.optionsJList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane2.setViewportView(this.optionsJList);
        this.addJButton.setText("Add");
        this.addJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharedComplibPanel.this.addActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText("* Shared Component Library Project must contain a functional \"build/complib\" directory.");
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 419, Short.MAX_VALUE).add((Component)this.jLabel3).add((Component)this.addJButton).add((Component)this.jLabel2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 84, -2).addPreferredGap(0).add((Component)this.addJButton).addPreferredGap(0).add((Component)this.jLabel2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Shared Component Libraries for Active Project:");
        this.sharedComplibJList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.sharedComplibJList);
        this.removeJButton.setText("Remove");
        this.removeJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharedComplibPanel.this.removeActionPerformed(actionEvent);
            }
        });
        this.refreshJButton.setText("Refresh All");
        this.refreshJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharedComplibPanel.this.refreshActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 419, Short.MAX_VALUE).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.removeJButton).addPreferredGap(0).add((Component)this.refreshJButton))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 67, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.removeJButton).add((Component)this.refreshJButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.messageJLabel)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.messageJLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void refreshActionPerformed(ActionEvent actionEvent) {
        try {
            csp.refreshSharedComplibsForActiveProject();
        }
        catch (Exception exception) {
            this.addErrorMessage(exception.getMessage());
            IdeUtil.logError(exception);
        }
        this.updateSharedComplibList();
    }

    private void removeActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.sharedComplibJList.getSelectedValues();
        HashSet<SharedComplib> hashSet = new HashSet<SharedComplib>();
        for (Object object : objectArray) {
            hashSet.add((SharedComplib)object);
        }
        try {
            csp.removeSharedComplibsFromActiveProject(hashSet);
        }
        catch (Exception exception) {
            this.addErrorMessage(exception.getMessage());
            IdeUtil.logError(exception);
        }
        this.updateSharedComplibList();
    }

    private void addActionPerformed(ActionEvent actionEvent) {
        ProjectWrapper projectWrapper = (ProjectWrapper)this.optionsJList.getSelectedValue();
        if (projectWrapper == null) {
            this.addErrorMessage("Select a Shared Component Library");
            return;
        }
        this.clearStatusMessage();
        Project project = projectWrapper.getProject();
        try {
            csp.addSharedComplibProject(project);
        }
        catch (Exception exception) {
            this.addErrorMessage(exception.getMessage());
            IdeUtil.logError(exception);
        }
        this.updateSharedComplibList();
    }

    private void updateSharedComplibList() {
        SharedComplib[] sharedComplibArray;
        SharedComplib[] sharedComplibArray2;
        try {
            sharedComplibArray2 = csp.getSharedComplibsForActiveProject();
            sharedComplibArray = sharedComplibArray2.toArray(new SharedComplib[sharedComplibArray2.size()]);
        }
        catch (ComplibException complibException) {
            this.addErrorMessage(complibException.getMessage());
            IdeUtil.logError(complibException);
            sharedComplibArray = new SharedComplib[]{};
        }
        sharedComplibArray2 = sharedComplibArray;
        this.sharedComplibJList.setModel(new AbstractListModel(){

            public int getSize() {
                return sharedComplibArray2.length;
            }

            public Object getElementAt(int n) {
                return sharedComplibArray2[n];
            }
        });
    }

    public void showDialog() {
        String string = NbBundle.getMessage(SharedComplibPanel.class, (String)"sharedComplib.dialogTitle");
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(SharedComplibPanel.class, (String)"sharedComplib.closeButton"));
        Object[] objectArray = new Object[]{jButton};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string, true, objectArray, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogDescriptor.setValid(true);
        dialog.setVisible(true);
    }

    private static class ProjectWrapper {
        private Project project;

        public ProjectWrapper(Project project) {
            this.project = project;
        }

        public String toString() {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
            return projectInformation.getDisplayName();
        }

        public Project getProject() {
            return this.project;
        }
    }
}

