/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.openide.ErrorManager;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(JTextComponent jTextComponent) {
        int n;
        Document document;
        int n2 = jTextComponent.getCaretPosition();
        if (n2 == (document = jTextComponent.getDocument()).getLength()) {
            return -1;
        }
        KeystrokeHandler keystrokeHandler = GsfEditorKitFactory.getBracketCompletion(document, n2);
        if (keystrokeHandler != null && (n = keystrokeHandler.getNextWordOffset(document, n2, false)) != -1) {
            return n;
        }
        try {
            return Utilities.getNextWord((JTextComponent)jTextComponent, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return -1;
        }
    }

    static int previousCamelCasePosition(JTextComponent jTextComponent) {
        int n;
        int n2 = jTextComponent.getCaretPosition();
        if (n2 == 0) {
            return -1;
        }
        Document document = jTextComponent.getDocument();
        KeystrokeHandler keystrokeHandler = GsfEditorKitFactory.getBracketCompletion(document, n2);
        if (keystrokeHandler != null && (n = keystrokeHandler.getNextWordOffset(document, n2, true)) != -1) {
            return n;
        }
        try {
            return Utilities.getPreviousWord((JTextComponent)jTextComponent, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return -1;
        }
    }

    static void replaceChar(JTextComponent jTextComponent, int n, char c) {
        if (!jTextComponent.isEditable()) {
            return;
        }
        CamelCaseOperations.replaceText(jTextComponent, n, 1, String.valueOf(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void replaceText(JTextComponent jTextComponent, int n, int n2, String string) {
        if (!jTextComponent.isEditable()) {
            return;
        }
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).atomicLock();
        }
        try {
            if (n2 > 0) {
                document.remove(n, n2);
            }
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        finally {
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).atomicUnlock();
            }
        }
    }
}

