/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.modules.gsf.GsfDataObject;
import org.netbeans.modules.gsf.Language;
import org.openide.ErrorManager;
import org.openide.actions.OpenAction;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;

public class GsfDataNode
extends DataNode {
    private static Map<String, Action[]> mimeTypeToActions = new HashMap<String, Action[]>();

    public GsfDataNode(GsfDataObject gsfDataObject, Language language) {
        super((DataObject)gsfDataObject, Children.LEAF);
        if (language != null && language.getIconBase() != null) {
            this.setIconBaseWithExtension(language.getIconBase());
        }
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        String string = this.getDataObject().getPrimaryFile().getMIMEType();
        if (!mimeTypeToActions.containsKey(string)) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Loaders/" + string + "/Actions");
                if (fileObject != null) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    int n = dataObjectArray.length;
                    for (int i = 0; i < n; ++i) {
                        InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
                        Class clazz = instanceCookie.instanceClass();
                        if (JSeparator.class.isAssignableFrom(clazz)) {
                            arrayList.add(null);
                            continue;
                        }
                        arrayList.add((Action)instanceCookie.instanceCreate());
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!arrayList.isEmpty()) {
                mimeTypeToActions.put(string, arrayList.toArray(new Action[arrayList.size()]));
            } else {
                mimeTypeToActions.put(string, super.getActions(bl));
            }
        }
        return mimeTypeToActions.get(string);
    }
}

