/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import org.netbeans.modules.gsf.GsfDataNode;
import org.netbeans.modules.gsf.Language;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfDataObject
extends MultiDataObject {
    private GenericEditorSupport jes;
    private Language language;

    public GsfDataObject(FileObject fileObject, MultiFileLoader multiFileLoader, Language language) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.language = language;
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                GsfDataObject.this.createEditorSupport().saveAs(fileObject, string);
            }
        }});
    }

    public Node createNodeDelegate() {
        return new GsfDataNode(this, this.language);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(GenericEditorSupport.class)) {
            return (T)((Node.Cookie)clazz.cast((Object)this.createEditorSupport()));
        }
        return (T)super.getCookie(clazz);
    }

    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        FileObject fileObject = this.getPrimaryEntry().copyRename(dataFolder.getPrimaryFile(), string, string2);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject;
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null && this.language.getGsfLanguage().getPreferredExtension() != null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.language.getGsfLanguage().getPreferredExtension());
        }
        DataObject dataObject = super.handleCreateFromTemplate(dataFolder, string);
        FileObject fileObject = dataObject.getPrimaryFile();
        assert (fileObject != null);
        return dataObject;
    }

    private synchronized GenericEditorSupport createEditorSupport() {
        if (this.jes == null) {
            this.jes = new GenericEditorSupport(this, this.language);
        }
        return this.jes;
    }

    public static final class GenericEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        public GenericEditorSupport(GsfDataObject gsfDataObject, Language language) {
            super((DataObject)gsfDataObject, (CloneableEditorSupport.Env)new Environment(gsfDataObject));
            this.setMIMEType(language.getMimeType());
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        public boolean close(boolean bl) {
            return super.close(bl);
        }

        private static class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(GsfDataObject gsfDataObject) {
                super((DataObject)gsfDataObject);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((GsfDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                GsfDataObject gsfDataObject = (GsfDataObject)this.getDataObject();
                if (gsfDataObject.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    gsfDataObject.getCookieSet().add((Node.Cookie)this.saveCookie);
                    gsfDataObject.setModified(true);
                }
            }

            public void removeSaveCookie() {
                GsfDataObject gsfDataObject = (GsfDataObject)this.getDataObject();
                if (gsfDataObject.getCookie(SaveCookie.class) != null) {
                    gsfDataObject.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    gsfDataObject.setModified(false);
                }
            }

            private class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((GenericEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }
}

