/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;

public class GsfHtmlFormatter
extends HtmlFormatter {
    protected boolean isDeprecated;
    protected boolean isParameter;
    protected boolean isType;
    protected boolean isName;
    protected boolean isEmphasis;
    protected StringBuilder sb = new StringBuilder();

    public void reset() {
        this.textLength = 0;
        this.sb.setLength(0);
    }

    public void appendHtml(String string) {
        this.sb.append(string);
    }

    public void appendText(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.textLength >= this.maxLength) {
                if (this.textLength != this.maxLength) break;
                this.sb.append("...");
                this.textLength += 3;
                break;
            }
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '>': {
                    if (i > 1 && string.charAt(i - 2) == ']' && string.charAt(i - 1) == ']') {
                        this.sb.append("&gt;");
                        break;
                    }
                    this.sb.append(c);
                    break;
                }
                case '&': {
                    this.sb.append("&amp;");
                    break;
                }
                default: {
                    this.sb.append(c);
                }
            }
            ++this.textLength;
        }
    }

    public void name(ElementKind elementKind, boolean bl) {
        assert (bl != this.isName);
        this.isName = bl;
        if (this.isName) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }

    public void parameters(boolean bl) {
        assert (bl != this.isParameter);
        this.isParameter = bl;
        if (this.isParameter) {
            this.sb.append("<font color=\"#808080\">");
        } else {
            this.sb.append("</font>");
        }
    }

    public void active(boolean bl) {
        this.emphasis(bl);
    }

    public void type(boolean bl) {
        assert (bl != this.isType);
        this.isType = bl;
        if (this.isType) {
            this.sb.append("<font color=\"#808080\">");
        } else {
            this.sb.append("</font>");
        }
    }

    public void deprecated(boolean bl) {
        assert (bl != this.isDeprecated);
        this.isDeprecated = bl;
        if (this.isDeprecated) {
            this.sb.append("<s>");
        } else {
            this.sb.append("</s>");
        }
    }

    public String getText() {
        assert (!(this.isParameter || this.isDeprecated || this.isName || this.isType));
        return this.sb.toString();
    }

    public void emphasis(boolean bl) {
        assert (bl != this.isEmphasis);
        this.isEmphasis = bl;
        if (this.isEmphasis) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }
}

