/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsfret.editor.semantic.ColoringManager;
import org.netbeans.modules.gsfret.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.editor.semantic.SequenceElement;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;

    SemanticHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        this.process(compilationInfo, document);
    }

    boolean process(CompilationInfo compilationInfo, final Document document) {
        final TreeSet<SequenceElement> treeSet = new TreeSet<SequenceElement>();
        if (this.isCancelled()) {
            return true;
        }
        long l = System.currentTimeMillis();
        Set<String> set = compilationInfo.getEmbeddedMimeTypes();
        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
        SortedSet<SequenceElement> sortedSet = GsfSemanticLayer.getLayer(SemanticHighlighter.class, document).getColorings();
        if (set.size() > 1 && compilationInfo.hasUnchangedResults() && sortedSet.size() > 0) {
            HashMap hashMap = new HashMap();
            ArrayList arrayList = null;
            Language language = null;
            for (SequenceElement sequenceElement : sortedSet) {
                List list;
                if (sequenceElement.language == language) {
                    list = arrayList;
                } else {
                    list = (List)hashMap.get(sequenceElement.language);
                    if (list == null) {
                        list = new ArrayList();
                        hashMap.put(sequenceElement.language, list);
                        language = sequenceElement.language;
                        arrayList = list;
                    }
                }
                list.add((SequenceElement)sequenceElement);
            }
            EditHistory editHistory = compilationInfo.getHistory();
            int n = editHistory.getStart();
            for (String string : set) {
                Object object;
                Object object2;
                Object object3;
                if (this.isCancelled()) {
                    return true;
                }
                Language language2 = languageRegistry.getLanguageByMimeType(string);
                if (language2 == null) continue;
                ParserResult parserResult = compilationInfo.getEmbeddedResult(string, 0);
                if (parserResult != null && parserResult.getUpdateState().isUnchanged()) {
                    object3 = (List)hashMap.get(language2);
                    if (object3 == null) continue;
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (SequenceElement)object2.next();
                        if (((SequenceElement)object).language != language2) continue;
                        OffsetRange offsetRange = ((SequenceElement)object).range;
                        if (offsetRange.getStart() > n) {
                            ((SequenceElement)object).range = new OffsetRange(editHistory.convertOriginalToEdited(offsetRange.getStart()), editHistory.convertOriginalToEdited(offsetRange.getEnd()));
                        }
                        treeSet.add((SequenceElement)object);
                    }
                    continue;
                }
                object3 = language2.getColoringManager();
                object2 = language2.getSemanticAnalyzer();
                if (object2 == null) continue;
                try {
                    object2.run((Object)compilationInfo);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (this.isCancelled()) {
                    object2.cancel();
                    return true;
                }
                object = object2.getHighlights();
                if (object == null) continue;
                for (OffsetRange offsetRange : object.keySet()) {
                    Set set2 = (Set)object.get(offsetRange);
                    if (set2 == null) continue;
                    ColoringAttributes.Coloring coloring = ((ColoringManager)object3).getColoring(set2);
                    treeSet.add(new SequenceElement(language2, offsetRange, coloring));
                }
            }
            GsfSemanticLayer.getLayer(SemanticHighlighter.class, document).setColorings(treeSet);
            return true;
        }
        for (String string : set) {
            if (this.isCancelled()) {
                return true;
            }
            long l2 = System.currentTimeMillis();
            Language language = languageRegistry.getLanguageByMimeType(string);
            if (language == null) continue;
            ColoringManager coloringManager = language.getColoringManager();
            SemanticAnalyzer semanticAnalyzer = language.getSemanticAnalyzer();
            if (semanticAnalyzer != null) {
                try {
                    semanticAnalyzer.run((Object)compilationInfo);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (this.isCancelled()) {
                    semanticAnalyzer.cancel();
                    return true;
                }
                Map map = semanticAnalyzer.getHighlights();
                if (map != null) {
                    for (OffsetRange offsetRange : map.keySet()) {
                        Set set3 = (Set)map.get(offsetRange);
                        if (set3 == null) continue;
                        ColoringAttributes.Coloring coloring = coloringManager.getColoring(set3);
                        treeSet.add(new SequenceElement(language, offsetRange, coloring));
                    }
                }
            }
            long l3 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Semantic (" + string + ")", new Object[]{compilationInfo.getFileObject(), l3 - l2});
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GsfSemanticLayer.getLayer(SemanticHighlighter.class, document).setColorings(treeSet);
            }
        });
        return false;
    }
}

