/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.support.CaretAwareSourceTaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsTask
extends ScanningCancellableTask<CompilationInfo> {
    static Language getHintsProviderLanguage(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getHintsProvider() == null) continue;
            return language;
        }
        return null;
    }

    @Override
    public void run(CompilationInfo compilationInfo) throws Exception {
        this.resume();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return;
        }
        int n = CaretAwareSourceTaskFactory.getLastPosition(compilationInfo.getFileObject());
        if (n == -1) {
            return;
        }
        Language language = SuggestionsTask.getHintsProviderLanguage(document, n);
        if (language == null) {
            return;
        }
        HintsProvider hintsProvider = language.getHintsProvider();
        assert (hintsProvider != null);
        GsfHintsManager gsfHintsManager = language.getHintsManager();
        if (gsfHintsManager == null) {
            return;
        }
        RuleContext ruleContext = gsfHintsManager.createRuleContext(compilationInfo, language, n, -1, -1);
        if (ruleContext == null) {
            return;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        ArrayList arrayList2 = new ArrayList();
        hintsProvider.computeSuggestions((HintsProvider.HintsManager)gsfHintsManager, ruleContext, arrayList2, n);
        for (Hint hint : arrayList2) {
            ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, false);
            arrayList.add(errorDescription);
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)SuggestionsTask.class.getName(), arrayList);
    }
}

