/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.text.NbDocument;

public class SourceFileObject {
    final FileObject file;
    private URI uri;
    private String text;
    private TokenHierarchy tokens;
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    public static SourceFileObject create(FileObject fileObject) {
        try {
            return new SourceFileObject(fileObject, false);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public SourceFileObject(FileObject fileObject, boolean bl) throws IOException {
        assert (fileObject != null);
        this.file = fileObject;
        if (bl) {
            this.text = this.getCharContentImpl().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer getCharContent(boolean bl) throws IOException {
        String string;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            string = this.text;
        }
        if (string != null) {
            return CharBuffer.wrap(string);
        }
        return this.getCharContentImpl();
    }

    public TokenHierarchy getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            this.getCharContentImpl();
        }
        return this.tokens;
    }

    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), encodingName);
    }

    public Reader openReader(boolean bl) throws IOException {
        return new InputStreamReader(this.openInputStream(), encodingName);
    }

    public OutputStream openOutputStream() throws IOException {
        StyledDocument styledDocument = DataLoadersBridge.getDefault().getDocument(this.file);
        if (styledDocument == null) {
            return new LckStream(this.file);
        }
        return new DocumentStream(styledDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        String string;
        Object object = this;
        synchronized (object) {
            string = this.text;
        }
        if (string != null) {
            return new ByteArrayInputStream(string.getBytes());
        }
        object = DataLoadersBridge.getDefault().getDocument(this.file);
        if (object == null) {
            return this.file.getInputStream();
        }
        final StringBuilder stringBuilder = new StringBuilder();
        object.render(new Runnable((Document)object){
            final /* synthetic */ Document val$doc;
            {
                this.val$doc = document;
            }

            public void run() {
                try {
                    stringBuilder.append(this.val$doc.getText(0, this.val$doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        });
        return new ByteArrayInputStream(stringBuilder.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        boolean bl;
        if (this.isModified() != null) {
            return false;
        }
        FileLock fileLock = this.file.lock();
        try {
            this.file.delete(fileLock);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                fileLock.releaseLock();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        fileLock.releaseLock();
        return bl;
    }

    public String getName() {
        return this.file.getNameExt();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    public synchronized URI toUri() {
        if (this.uri == null) {
            try {
                this.uri = URI.create(this.file.getURL().toExternalForm());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return this.uri;
    }

    public long getLastModified() {
        if (this.isModified() == null) {
            return this.file.lastModified().getTime();
        }
        return System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        if (object instanceof SourceFileObject) {
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.file.equals(sourceFileObject.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public StyledDocument getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    public void runAtomic(Runnable runnable) {
        assert (runnable != null);
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
    }

    private EditorCookie isModified() {
        return DataLoadersBridge.getDefault().isModified(this.file);
    }

    public EditorCookie isOpened() {
        return (EditorCookie)DataLoadersBridge.getDefault().getSafeCookie(this.file, EditorCookie.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer getCharContentImpl() throws IOException {
        Readable readable;
        final StyledDocument styledDocument = DataLoadersBridge.getDefault().getDocument(this.file);
        final char[][] cArrayArray = new char[1][];
        final int[] nArray = new int[1];
        if (styledDocument == null) {
            int n;
            readable = this.openReader(true);
            int n2 = 0;
            try {
                int n3;
                n = (int)this.file.getSize();
                cArrayArray[0] = new char[n + 1];
                while ((n3 = ((Reader)readable).read(cArrayArray[0], n2, n - n2)) > 0 && (n2 += n3) < n) {
                }
            }
            finally {
                ((Reader)readable).close();
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (cArrayArray[0][i] == '\r') {
                    if (i + 1 < n2 && cArrayArray[0][i + 1] == '\n') continue;
                    cArrayArray[0][n++] = 10;
                    continue;
                }
                cArrayArray[0][n++] = cArrayArray[0][i];
            }
            nArray[0] = n;
        } else {
            styledDocument.render(new Runnable(){

                public void run() {
                    try {
                        int n = styledDocument.getLength();
                        cArrayArray[0] = new char[n + 1];
                        styledDocument.getText(0, n).getChars(0, n, cArrayArray[0], 0);
                        nArray[0] = n;
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            });
        }
        cArrayArray[0][nArray[0]] = 10;
        readable = CharBuffer.wrap(cArrayArray[0], 0, nArray[0]);
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.file.getMIMEType());
        if (language != null && language.getGsfLanguage() != null) {
            org.netbeans.api.lexer.Language language2 = language.getGsfLanguage().getLexerLanguage();
            this.tokens = TokenHierarchy.create((CharSequence)((Object)readable), (boolean)true, (org.netbeans.api.lexer.Language)language2, null, null);
        }
        return readable;
    }

    private static StyledDocument getDocument(EditorCookie editorCookie) {
        return editorCookie == null ? null : editorCookie.getDocument();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument styledDocument) {
            assert (styledDocument != null);
            this.doc = styledDocument;
            this.data = new byte[2048];
            this.pos = 0;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureSize(n2);
            System.arraycopy(byArray, n, this.data, this.pos, n2);
            this.pos += n2;
        }

        public synchronized void write(byte[] byArray) throws IOException {
            this.ensureSize(byArray.length);
            System.arraycopy(byArray, 0, this.data, this.pos, byArray.length);
            this.pos += byArray.length;
        }

        public synchronized void write(int n) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(n & 0xFF);
        }

        private void ensureSize(int n) {
            int n2 = this.pos + n;
            if (this.data.length < n2) {
                int n3;
                for (n3 = this.data.length + 2048; n3 < n2; n3 += 2048) {
                }
                byte[] byArray = new byte[n3];
                System.arraycopy(this.data, 0, byArray, 0, this.pos);
                this.data = byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                            DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, encodingName), null);
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            ErrorManager.getDefault().notify((Throwable)unsupportedEncodingException);
                        }
                    }
                });
            }
            finally {
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LckStream(FileObject fileObject) throws IOException {
            assert (fileObject != null);
            this.lock = fileObject.lock();
            try {
                this.delegate = fileObject.getOutputStream(this.lock);
            }
            finally {
                if (this.delegate == null) {
                    this.lock.releaseLock();
                }
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.delegate.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate.write(byArray);
        }

        public void write(int n) throws IOException {
            this.delegate.write(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.releaseLock();
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }
}

