/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Index
extends org.netbeans.modules.gsf.api.Index {
    protected Language language;
    private static final int VERSION = 1;
    private static final int SUBVERSION = 118;
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SEGMENTS_FILE = "segments";
    private static final String CLASSES = "classes";
    private static final String SLICE_PREFIX = "s";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "gsf-index" + File.separatorChar + 1 + '.' + 118;
    protected static final String PREINDEXED = "netbeans-index-";
    private static final String PREINDEXED_MARKER = "static";
    private static final boolean COMPUTE_INDEX = Boolean.getBoolean("ruby.computeindex");
    private static Map<Language, LanguageContext> contexts = new HashMap<Language, LanguageContext>();
    private static List<FileObject> preindexRoots;

    protected Index(Language language) {
        this.language = language;
    }

    public abstract Map<String, String> getTimeStamps() throws IOException;

    public abstract void store(String var1, List<IndexDocument> var2) throws IOException;

    public abstract void batchStore(List<IndexBatchEntry> var1, boolean var2) throws IOException;

    public abstract boolean isValid(boolean var1) throws IOException;

    public abstract boolean isUpToDate(String var1, long var2) throws IOException;

    public abstract void clear() throws IOException;

    public abstract void close() throws IOException;

    static synchronized LanguageContext getContext(Language language) {
        LanguageContext languageContext = contexts.get(language);
        if (languageContext == null) {
            languageContext = new LanguageContext(language);
            contexts.put(language, languageContext);
        }
        return languageContext;
    }

    public static URL getSourceRootForClassFolder(Language language, URL uRL) {
        if ("file".equals(uRL.getProtocol())) {
            try {
                File file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
                File file2 = file.getParentFile();
                if (file2 == null) {
                    return null;
                }
                LanguageContext languageContext = Index.getContext(language);
                File file3 = file2.getParentFile();
                if (file3 == null || !((Object)file3).equals(languageContext.cacheFolder)) {
                    return null;
                }
                String string = languageContext.segments.getProperty(file2.getName());
                if (string != null) {
                    try {
                        return new URL(string);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    public static void addPreindexRoot(FileObject fileObject) {
        Index.getPreindexRoots();
        if (!preindexRoots.contains(fileObject)) {
            preindexRoots.add(fileObject);
        }
    }

    private static List<FileObject> getPreindexRoots() {
        if (preindexRoots == null) {
            preindexRoots = new ArrayList<FileObject>();
            for (FileObject fileObject : LanguageRegistry.getInstance().getLibraryFos()) {
                preindexRoots.add(fileObject);
            }
        }
        return preindexRoots;
    }

    public static synchronized File getDataFolder(Language language, URL uRL) throws IOException {
        Object object;
        File file;
        File file2;
        LanguageContext languageContext = Index.getContext(language);
        languageContext.loadSegments();
        String string = uRL.toExternalForm();
        String string2 = (String)languageContext.invertedSegments.get(string);
        FileObject fileObject = null;
        if (string2 == null) {
            string2 = SLICE_PREFIX + ++languageContext.index;
            while (languageContext.segments.getProperty(string2) != null) {
                string2 = SLICE_PREFIX + ++languageContext.index;
            }
            languageContext.segments.put(string2, string);
            languageContext.invertedSegments.put(string, string2);
            file2 = URLMapper.findFileObject((URL)uRL);
            if (file2 != null) {
                file = language.getIndexer();
                object = PREINDEXED + file.getIndexerName() + "-" + file.getIndexVersion();
                fileObject = file2.getFileObject((String)object, "zip");
                if (fileObject == null && !COMPUTE_INDEX) {
                    for (FileObject fileObject2 : Index.getPreindexRoots()) {
                        String string3;
                        if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)file2) || (string3 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)file2)) == null || string3.length() <= 0) continue;
                        FileObject fileObject3 = file.getPreindexedDb();
                        if (fileObject3 == null) break;
                        fileObject = fileObject3.getFileObject(string3 + "/" + (String)object + ".zip");
                        break;
                    }
                }
            }
            languageContext.storeSegments();
        }
        if (!(file2 = FileUtil.normalizeFile((File)new File(languageContext.cacheFolder, string2))).exists()) {
            file2.mkdir();
            if (fileObject != null) {
                file = FileUtil.toFile(fileObject);
                object = FileUtil.toFileObject((File)file2);
                if (object != null) {
                    Index.extractZip(object, new BufferedInputStream(new FileInputStream(file)));
                }
            }
        }
        return file2;
    }

    static boolean isPreindexed(File file) {
        return new File(file, PREINDEXED_MARKER).exists();
    }

    private static void extractZip(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                Index.extractZipImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (zipEntry.isDirectory()) {
                FileUtil.createFolder((FileObject)fileObject, (String)string);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    static void preindex(Language language, URL uRL) {
        try {
            File[] fileArray;
            Indexer indexer = language.getIndexer();
            if (!indexer.acceptQueryPath(uRL.toExternalForm())) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            File file = Index.getDataFolder(language, uRL);
            String string = PREINDEXED + indexer.getIndexerName() + "-" + indexer.getIndexVersion();
            File file2 = new File(FileUtil.toFile((FileObject)fileObject), string + ".zip");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            ZipEntry zipEntry = new ZipEntry(PREINDEXED_MARKER);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            File file3 = new File(file, "gsf");
            assert (file3.exists());
            ClassIndexImpl classIndexImpl = ClassIndexManager.get(language).getUsagesQuery(uRL);
            classIndexImpl.close();
            if (file3.list().length == 0) {
                classIndexImpl.storeEmpty();
                classIndexImpl.close();
            }
            for (File file4 : fileArray = file3.listFiles()) {
                ZipEntry zipEntry2 = new ZipEntry("gsf/" + file4.getName());
                zipOutputStream.putNextEntry(zipEntry2);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file4));
                FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.finish();
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    static String getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        return string;
    }

    private static class LanguageContext {
        private Properties segments;
        private Map<String, String> invertedSegments;
        private File cacheFolder;
        private File segmentsFile;
        private int index = 0;
        private Language language;

        private LanguageContext(Language language) {
            this.language = language;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadSegments() throws IOException {
            if (this.segments == null) {
                File file = this.getCacheFolder();
                assert (file != null);
                this.segments = new Properties();
                this.invertedSegments = new HashMap<String, String>();
                this.segmentsFile = FileUtil.normalizeFile((File)new File(file, Index.SEGMENTS_FILE));
                if (this.segmentsFile.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(this.segmentsFile);
                    try {
                        this.segments.load(fileInputStream);
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                }
                for (Map.Entry entry : this.segments.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    this.invertedSegments.put(string2, string);
                    try {
                        this.index = Math.max(this.index, Integer.parseInt(string.substring(Index.SLICE_PREFIX.length())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager.getDefault().notify((Throwable)numberFormatException);
                    }
                }
                assert (this.segmentsFile != null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeSegments() throws IOException {
            assert (this.segmentsFile != null);
            FileOutputStream fileOutputStream = new FileOutputStream(this.segmentsFile);
            try {
                this.segments.store(fileOutputStream, null);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }

        private synchronized File getCacheFolder() {
            if (this.cacheFolder == null) {
                String string = Index.getNbUserDir();
                assert (string != null);
                File file = new File(string);
                this.cacheFolder = FileUtil.normalizeFile((File)new File(file, INDEX_DIR));
                Indexer indexer = this.language.getIndexer();
                assert (indexer != null) : this.language;
                this.cacheFolder = new File(this.cacheFolder, indexer.getIndexerName() + File.separator + indexer.getIndexVersion());
                if (!this.cacheFolder.exists()) {
                    boolean bl = this.cacheFolder.mkdirs();
                    assert (bl) : "Cannot create cache folder";
                } else assert (this.cacheFolder.isDirectory() && this.cacheFolder.canRead() && this.cacheFolder.canWrite());
            }
            return this.cacheFolder;
        }

        synchronized void setCacheFolder(File file) {
            assert (file != null && file.exists() && file.canRead() && file.canWrite());
            this.cacheFolder = file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanOperator {
        AND,
        OR;

    }
}

