/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernateweb.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernateweb.framework.HibernateWebModuleExtender;
import org.netbeans.modules.hibernateweb.framework.Util;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HibernateFrameworkProvider
extends WebFrameworkProvider {
    public HibernateFrameworkProvider() {
        super(NbBundle.getMessage(HibernateFrameworkProvider.class, (String)"HibernateFramework_Name"), NbBundle.getMessage(HibernateFrameworkProvider.class, (String)"HibernateFramework_Description"));
    }

    public boolean isInWebModule(WebModule webModule) {
        return this.getConfigurationFiles(webModule).length != 0;
    }

    public WebModuleExtender createWebModuleExtender(WebModule webModule, ExtenderController extenderController) {
        boolean bl = webModule == null || !this.isInWebModule(webModule);
        HibernateWebModuleExtender hibernateWebModuleExtender = new HibernateWebModuleExtender(bl, webModule, extenderController);
        return hibernateWebModuleExtender;
    }

    public File[] getConfigurationFiles(WebModule webModule) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Project project = Util.getEnclosingProjectFromWebModule(webModule);
        if (project == null) {
            return new File[0];
        }
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return new File[0];
        }
        List list = hibernateEnvironment.getAllHibernateConfigFileObjects();
        for (FileObject fileObject : list) {
            arrayList.add(FileUtil.toFile((FileObject)fileObject));
        }
        return arrayList.toArray(new File[0]);
    }
}

