/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.ProcessDICookie;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.ProcessInstancesModel;
import org.netbeans.modules.bpel.debugger.api.Tracer;
import org.netbeans.modules.bpel.debugger.api.TracerAccess;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class BpelDebugger {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_PROCESS_INSTANCE = "currentProcessInstance";
    public static final String PROP_CURRENT_PROCESS_INSTANCE_STATE = "currentProcessInstanceState";
    public static final String PROP_CURRENT_POSITION = "currentPosition";
    public static final int STATE_STARTING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_DISCONNECTED = 4;
    private PropertyChangeSupport myPcs;
    private ContextProvider myLookupProvider;
    private Tracer mTracer;

    protected BpelDebugger(ContextProvider contextProvider) {
        this.myLookupProvider = contextProvider;
        this.myPcs = new PropertyChangeSupport(this);
    }

    public Tracer getTracer() {
        if (this.mTracer == null) {
            this.mTracer = TracerAccess.getTracer(this.getLookupProvider());
        }
        return this.mTracer;
    }

    public static void start(Properties properties) {
        ProcessDICookie processDICookie = ProcessDICookie.create(properties);
        DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-ProcessDICookie", (Object[])new Object[]{processDICookie}));
    }

    public abstract void finish();

    public abstract void stepInto();

    public abstract void stepOver();

    public abstract void stepOut();

    public abstract void pause();

    public abstract void resume();

    public abstract int getState();

    public abstract ProcessInstancesModel getProcessInstancesModel();

    public abstract int getCurrentProcessInstanceState();

    public abstract ProcessInstance getCurrentProcessInstance();

    public abstract void setCurrentProcessInstance(ProcessInstance var1);

    public abstract Position getCurrentPosition();

    public abstract Exception getException();

    public abstract void runToCursor(LineBreakpoint var1);

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.myPcs.firePropertyChange(string, object, object2);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.removePropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final ContextProvider getLookupProvider() {
        return this.myLookupProvider;
    }
}

