/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaMembersModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private String pattern = "";
    private String patternLowerCase = "";
    private FileObject fileObject;
    private ElementHandle[] elementHandles;
    private FilterModel filterModel;

    public JavaMembersModel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elementArray == null || elementArray.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>(elementArray.length);
            for (Element element : elementArray) {
                arrayList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = arrayList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elementArray, compilationInfo);
        this.filterModel = new FilterModel(this);
    }

    FilterModel getFilterModel() {
        return this.filterModel;
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandleArray) {
        if (elementHandleArray == null && elementHandleArray.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> arrayList = new ArrayList<Element>(elementHandleArray.length);
                        for (ElementHandle elementHandle : elementHandleArray) {
                            arrayList.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                        Element[] elementArray = arrayList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaMembersModel.this.update(elementArray, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void update(Element[] elementArray, CompilationInfo compilationInfo) {
        if (elementArray == null && elementArray.length == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Element element : elementArray) {
            if (element.getKind() == ElementKind.PACKAGE) {
                defaultMutableTreeNode.add(new PackageTreeNode(this.fileObject, (PackageElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.ANNOTATION_TYPE) {
                defaultMutableTreeNode.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                defaultMutableTreeNode.add(new ConstructorTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                defaultMutableTreeNode.add(new MethodTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.FIELD) {
                defaultMutableTreeNode.add(new FieldTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            defaultMutableTreeNode.add(new EnumConstantTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
        }
        this.setRoot(defaultMutableTreeNode);
    }

    private static boolean include(AbstractMembersTreeNode abstractMembersTreeNode, String string, String string2) {
        ElementKind elementKind = abstractMembersTreeNode.getElementKind();
        if (elementKind == ElementKind.CLASS || elementKind == ElementKind.INTERFACE || elementKind == ElementKind.ENUM || elementKind == ElementKind.ANNOTATION_TYPE || elementKind == ElementKind.PACKAGE) {
            return true;
        }
        Set<Modifier> set = abstractMembersTreeNode.getModifiers();
        if (elementKind == ElementKind.CONSTRUCTOR) {
            if (!JavaMembersAndHierarchyOptions.isShowConstructors()) {
                return false;
            }
            if (!(set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
        } else if (elementKind == ElementKind.METHOD) {
            if (!JavaMembersAndHierarchyOptions.isShowMethods()) {
                return false;
            }
            if (!(set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        } else if (elementKind == ElementKind.FIELD) {
            if (!JavaMembersAndHierarchyOptions.isShowFields()) {
                return false;
            }
            if (!(set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        } else if (elementKind == ElementKind.ENUM_CONSTANT) {
            if (!JavaMembersAndHierarchyOptions.isShowEnumConstants()) {
                return false;
            }
            if (!(set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        }
        return JavaMembersModel.patternMatch(abstractMembersTreeNode, string, string2);
    }

    static boolean patternMatch(JavaElement javaElement, String string) {
        return JavaMembersModel.patternMatch(javaElement, string, string.toLowerCase());
    }

    static boolean patternMatch(JavaElement javaElement, String string, String string2) {
        return Utils.patternMatch(javaElement, string, string2);
    }

    static class FilterModel
    extends DefaultTreeModel {
        private JavaMembersModel javaMembersModel;
        private String pattern = "";
        private String patternLowerCase = "";

        FilterModel(JavaMembersModel javaMembersModel) {
            super(null);
            this.javaMembersModel = javaMembersModel;
        }

        void update() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            TreeNode treeNode = (TreeNode)this.javaMembersModel.getRoot();
            int n = treeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                AbstractMembersTreeNode abstractMembersTreeNode = (AbstractMembersTreeNode)treeNode.getChildAt(i);
                if (!JavaMembersModel.include(abstractMembersTreeNode, this.pattern, this.patternLowerCase)) continue;
                FilterNode filterNode = new FilterNode(abstractMembersTreeNode);
                filterNode.loadChildren();
                defaultMutableTreeNode.add(filterNode);
            }
            this.setRoot(defaultMutableTreeNode);
        }

        String getPattern() {
            return this.pattern;
        }

        void setPattern(String string) {
            this.pattern = string;
            this.patternLowerCase = string == null ? null : string.toLowerCase();
        }

        void fireTreeNodesChanged() {
            super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterNode
        extends DefaultMutableTreeNode
        implements JavaElement {
            private AbstractMembersTreeNode abstractMembersTreeNode;

            FilterNode(AbstractMembersTreeNode abstractMembersTreeNode) {
                this.abstractMembersTreeNode = abstractMembersTreeNode;
            }

            private void loadChildren() {
                int n = this.abstractMembersTreeNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    AbstractMembersTreeNode abstractMembersTreeNode = (AbstractMembersTreeNode)this.abstractMembersTreeNode.getChildAt(i);
                    if (!JavaMembersModel.include(abstractMembersTreeNode, FilterModel.this.pattern, FilterModel.this.patternLowerCase)) continue;
                    FilterNode filterNode = new FilterNode(abstractMembersTreeNode);
                    filterNode.loadChildren();
                    this.add(filterNode);
                }
            }

            @Override
            public String getName() {
                return this.abstractMembersTreeNode.getName();
            }

            @Override
            public Set<Modifier> getModifiers() {
                return this.abstractMembersTreeNode.getModifiers();
            }

            @Override
            public ElementKind getElementKind() {
                return this.abstractMembersTreeNode.getElementKind();
            }

            @Override
            public String getLabel() {
                return this.abstractMembersTreeNode.getLabel();
            }

            @Override
            public String getFQNLabel() {
                return this.abstractMembersTreeNode.getLabel();
            }

            @Override
            public Icon getIcon() {
                return this.abstractMembersTreeNode.getIcon();
            }

            @Override
            public String getTooltip() {
                return this.abstractMembersTreeNode.getTooltip();
            }

            @Override
            public ElementHandle getElementHandle() {
                return this.abstractMembersTreeNode.getElementHandle();
            }

            @Override
            public FileObject getFileObject() {
                return this.abstractMembersTreeNode.getFileObject();
            }

            @Override
            public ElementJavadoc getJavaDoc() {
                return this.abstractMembersTreeNode.getJavaDoc();
            }

            @Override
            public void gotoElement() {
                this.abstractMembersTreeNode.gotoElement();
            }

            @Override
            public String toString() {
                return this.abstractMembersTreeNode.toString();
            }
        }
    }

    class EnumConstantTreeNode
    extends AbstractMembersTreeNode {
        EnumConstantTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class FieldTreeNode
    extends AbstractMembersTreeNode {
        FieldTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class MethodTreeNode
    extends AbstractMembersTreeNode {
        MethodTreeNode(FileObject fileObject, ExecutableElement executableElement, CompilationInfo compilationInfo) {
            super(fileObject, executableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class ConstructorTreeNode
    extends AbstractMembersTreeNode {
        ConstructorTreeNode(FileObject fileObject, ExecutableElement executableElement, CompilationInfo compilationInfo) {
            super(fileObject, executableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class TypeTreeNode
    extends AbstractMembersTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
            super(fileObject, typeElement, compilationInfo);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int n) {
            Element element2;
            Object object;
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> list = typeElement.getEnclosedElements();
            for (Element object3 : list) {
                object = null;
                if (object3.getKind() == ElementKind.CLASS || object3.getKind() == ElementKind.INTERFACE || object3.getKind() == ElementKind.ENUM) {
                    if (!JavaMembersAndHierarchyOptions.isShowInner() || JavaMembersAndHierarchyOptions.isShowInherited()) continue;
                    object = new TypeTreeNode(this.getFileObject(), (TypeElement)object3, compilationInfo);
                } else {
                    Object object2 = object3.getModifiers();
                    if (object3.getKind() == ElementKind.CONSTRUCTOR) {
                        if (!JavaMembersAndHierarchyOptions.isShowConstructors()) continue;
                        element2 = (ExecutableElement)object3;
                        object = new ConstructorTreeNode(this.getFileObject(), (ExecutableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.METHOD) {
                        if (!JavaMembersAndHierarchyOptions.isShowMethods()) continue;
                        element2 = (ExecutableElement)object3;
                        object = new MethodTreeNode(this.getFileObject(), (ExecutableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.FIELD) {
                        if (!JavaMembersAndHierarchyOptions.isShowFields()) continue;
                        element2 = (VariableElement)object3;
                        object = new FieldTreeNode(this.getFileObject(), (VariableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.ENUM_CONSTANT) {
                        if (!JavaMembersAndHierarchyOptions.isShowEnumConstants()) continue;
                        element2 = (VariableElement)object3;
                        object = new EnumConstantTreeNode(this.getFileObject(), (VariableElement)element2, compilationInfo);
                    }
                }
                if (object == null) continue;
                this.insert((MutableTreeNode)object, n++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInherited()) {
                TypeElement typeElement2;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement()) != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName())) {
                    this.insert(new TypeTreeNode(this.getFileObject(), typeElement2, compilationInfo, true), n++);
                }
                List<? extends TypeMirror> list2 = typeElement.getInterfaces();
                for (Object object2 : list2) {
                    element2 = (TypeElement)((DeclaredType)object2).asElement();
                    this.insert(new TypeTreeNode(this.getFileObject(), (TypeElement)element2, compilationInfo, true), n++);
                }
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole && JavaMembersAndHierarchyOptions.isShowInherited()) {
                for (Element element3 : list) {
                    if (element3.getKind() != ElementKind.CLASS && element3.getKind() != ElementKind.INTERFACE && element3.getKind() != ElementKind.ENUM) continue;
                    object = new TypeTreeNode(this.getFileObject(), (TypeElement)element3, compilationInfo);
                    this.insert((MutableTreeNode)object, n++);
                }
            }
            return n;
        }
    }

    class PackageTreeNode
    extends AbstractMembersTreeNode {
        PackageTreeNode(FileObject fileObject, PackageElement packageElement, CompilationInfo compilationInfo) {
            super(fileObject, packageElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractMembersTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String FQNlabel = "";
        private String tooltip = null;
        private Icon icon = null;
        private ElementJavadoc javaDoc;

        AbstractMembersTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                this.setName(element.getEnclosingElement().getSimpleName().toString());
            } else {
                this.setName(element.getSimpleName().toString());
            }
            this.setIcon(ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setFQNLabel(Utils.format(element, false, true));
            this.setToolTip(Utils.format(element, true, JavaMembersAndHierarchyOptions.isShowFQN()));
            this.loadChildren(element, compilationInfo);
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        protected void setName(String string) {
            this.name = string;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String string) {
            this.label = string;
        }

        @Override
        public String getFQNLabel() {
            return this.FQNlabel;
        }

        protected void setFQNLabel(String string) {
            this.FQNlabel = string;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String string) {
            this.tooltip = string;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public ElementJavadoc getJavaDoc() {
            if (this.javaDoc == null) {
                if (this.fileObject == null) {
                    return null;
                }
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
                if (javaSource != null) {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element element = AbstractMembersTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                                AbstractMembersTreeNode.this.setJavaDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
                            }
                        }, true);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
            return this.javaDoc;
        }

        public void setJavaDoc(ElementJavadoc elementJavadoc) {
            this.javaDoc = elementJavadoc;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public ElementKind getElementKind() {
            return this.elementKind;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return JavaMembersAndHierarchyOptions.isShowFQN() ? this.getFQNLabel() : this.getLabel();
        }

        protected void openElementHandle() {
            if (this.fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembersModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
                return;
            }
            if (this.elementHandle == null) {
                return;
            }
            if (!ElementOpen.open((ClasspathInfo)ClasspathInfo.create((FileObject)this.fileObject), this.elementHandle)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembersModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
            }
        }
    }
}

