/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassScanner
extends TreePathScanner<TypeElement, Void> {
    private Trees trees;
    private Elements elements;
    private String binaryClassName;
    private String[] classExcludeNames;

    public ClassScanner(Trees trees, Elements elements, String string, String[] stringArray) {
        this.trees = trees;
        this.elements = elements;
        this.binaryClassName = string;
        this.classExcludeNames = stringArray;
    }

    @Override
    public TypeElement reduce(TypeElement typeElement, TypeElement typeElement2) {
        if (typeElement != null) {
            return typeElement;
        }
        return typeElement2;
    }

    @Override
    public TypeElement visitClass(ClassTree classTree, Void void_) {
        TypeElement typeElement = (TypeElement)this.trees.getElement(this.getCurrentPath());
        if (typeElement == null) {
            return (TypeElement)super.visitClass(classTree, void_);
        }
        String string = this.elements.getBinaryName(typeElement).toString();
        if (this.match(string)) {
            return typeElement;
        }
        return (TypeElement)super.visitClass(classTree, void_);
    }

    private boolean match(String string) {
        if (ClassScanner.match(string, this.binaryClassName)) {
            if (this.classExcludeNames != null) {
                for (String string2 : this.classExcludeNames) {
                    if (!ClassScanner.match(string, string2)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }
}

