/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.navigation;

import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ModelSetListener;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.navigation.VWPContentModel;

public class FacesModelSetListener
implements ModelSetListener {
    private static Logger LOGGER = Logger.getLogger(FacesModelSetListener.class.getName());
    private WeakReference<VWPContentModel> refVWPContentModel;

    public FacesModelSetListener(VWPContentModel vWPContentModel) {
        this.setVwpContentModel(vWPContentModel);
    }

    public void modelAdded(Model model) {
        LOGGER.finest("Model Added()");
    }

    public void modelChanged(Model model) {
        final VWPContentModel vWPContentModel = this.getVwpContentModel();
        if (model != null && vWPContentModel != null) {
            FacesModel facesModel = vWPContentModel.getFacesModel();
            LOGGER.finest("Model Changed()");
            if (model.equals(facesModel) || model.getFile().getExt().equals("jspf") && this.getVwpContentModel().isKnownFragementModel(facesModel, facesModel.getRootBean(), model)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        vWPContentModel.updateModel();
                    }
                });
            }
        } else {
            LOGGER.fine("Values of one of the model is null:");
            LOGGER.fine("VWPContentModel: " + (Object)((Object)vWPContentModel));
            LOGGER.fine("MyModel (passed in): " + model);
        }
    }

    public void modelRemoved(Model model) {
        LOGGER.finest("Model Removed()");
    }

    public void modelProjectChanged() {
        LOGGER.finest("Model Project Changed()");
    }

    private VWPContentModel getVwpContentModel() {
        VWPContentModel vWPContentModel = null;
        if (this.refVWPContentModel != null) {
            vWPContentModel = (VWPContentModel)((Object)this.refVWPContentModel.get());
        }
        return vWPContentModel;
    }

    private void setVwpContentModel(VWPContentModel vWPContentModel) {
        this.refVWPContentModel = new WeakReference<VWPContentModel>(vWPContentModel);
    }
}

