/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.navigation;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.navigation.VWPContentModel;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModel;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

public class VWPContentModelProvider
implements PageContentModelProvider {
    private Map<FileObject, Reference<VWPContentModel>> map = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageContentModel getPageContentModel(FileObject fileObject) {
        Reference<VWPContentModel> reference = this.map.get(fileObject);
        VWPContentModel vWPContentModel = null;
        if (reference != null && (vWPContentModel = reference.get()) != null) {
            return vWPContentModel;
        }
        if (JsfProjectUtils.isJsfProjectFile((FileObject)fileObject)) {
            FacesModelSet facesModelSet = FacesModelSet.getInstance((FileObject)fileObject);
            FacesModel facesModel = null;
            if (facesModelSet != null) {
                FacesModelSet facesModelSet2 = facesModelSet;
                synchronized (facesModelSet2) {
                    facesModel = facesModelSet.getFacesModel(fileObject);
                    if (facesModel == null) {
                        return null;
                    }
                }
            } else {
                return null;
            }
            vWPContentModel = new VWPContentModel(this, facesModel);
            if (vWPContentModel != null) {
                this.map.put(fileObject, new WeakReference<VWPContentModel>(vWPContentModel));
                fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDeleted(FileEvent fileEvent) {
                        FileObject fileObject = fileEvent.getFile();
                        VWPContentModelProvider.this.map.remove(fileObject);
                        super.fileDeleted(fileEvent);
                    }
                });
            }
        }
        return vWPContentModel;
    }

    public void removeModel(VWPContentModel vWPContentModel) {
        Set<Map.Entry<FileObject, Reference<VWPContentModel>>> set = this.map.entrySet();
        for (Map.Entry<FileObject, Reference<VWPContentModel>> entry : set) {
            if (entry == null || entry.getValue() == null || entry.getValue().get() == null || !((Object)((Object)entry.getValue().get())).equals((Object)vWPContentModel)) continue;
            this.map.remove(entry.getKey());
            break;
        }
    }

    public FileObject isNewPageContentModel(FileObject fileObject) {
        FileObject fileObject2 = JsfProjectUtils.getJspForJava((FileObject)fileObject);
        if (this.map.get(fileObject2) == null) {
            return fileObject2;
        }
        return null;
    }
}

