/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.httpserver.HostPropertyEditor;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HostPropertyCustomEditor
extends JPanel
implements HelpCtx.Provider,
ActionListener,
PropertyChangeListener {
    private HostPropertyEditor editor;
    private JRadioButton anyRadioButton;
    private ButtonGroup buttonGroup;
    private JLabel grantLabel;
    private JScrollPane grantScrollPane;
    private JTextArea grantTextArea;
    private JLabel hostLabel;
    private JRadioButton selectedRadioButton;

    public HostPropertyCustomEditor(HostPropertyEditor hostPropertyEditor, PropertyEnv propertyEnv) {
        this.editor = hostPropertyEditor;
        this.initComponents();
        this.initAccessibility();
        this.anyRadioButton.addActionListener(this);
        this.selectedRadioButton.addActionListener(this);
        this.setPreferredSize(new Dimension(300, 200));
        HttpServerSettings.HostProperty hostProperty = (HttpServerSettings.HostProperty)this.editor.getValue();
        if ("any".equals(hostProperty.getHost())) {
            this.anyRadioButton.setSelected(true);
            this.grantTextArea.setText("");
        } else if ("local".equals(hostProperty.getHost())) {
            this.selectedRadioButton.setSelected(true);
            this.grantTextArea.setText(hostProperty.getGrantedAddresses());
        }
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.anyRadioButton) {
                this.grantLabel.setEnabled(false);
                this.grantTextArea.setEnabled(false);
            } else if (actionEvent.getSource() == this.selectedRadioButton) {
                this.grantLabel.setEnabled(true);
                this.grantTextArea.setEnabled(true);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void initAccessibility() {
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_HostLabelA11yDesc"));
        this.grantLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_GrantLabelA11yDesc"));
        this.grantTextArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_GrantTextAreaA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_HostPropertyPanelA11yDesc"));
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.hostLabel = new JLabel();
        this.anyRadioButton = new JRadioButton();
        this.selectedRadioButton = new JRadioButton();
        this.grantLabel = new JLabel();
        this.grantScrollPane = new JScrollPane();
        this.grantTextArea = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_HostLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.buttonGroup.add(this.anyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.anyRadioButton, (String)NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_AnyRadioButton"));
        this.anyRadioButton.setToolTipText(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_AnyRadioButtonA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.anyRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.selectedRadioButton);
        this.selectedRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.selectedRadioButton, (String)NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_SelectedRadioButton"));
        this.selectedRadioButton.setToolTipText(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_SelectedRadioButtonA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.selectedRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.grantLabel, (String)NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_GrantLabel"));
        this.grantLabel.setLabelFor(this.grantTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 2, 0);
        this.add((Component)this.grantLabel, gridBagConstraints);
        this.grantTextArea.setToolTipText(NbBundle.getBundle(HostPropertyCustomEditor.class).getString("ACS_GrantTextAreaA11yDesc"));
        this.grantScrollPane.setViewportView(this.grantTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.grantScrollPane, gridBagConstraints);
    }

    private Object getPropertyValue() throws IllegalStateException {
        if (this.anyRadioButton.isSelected()) {
            return new HttpServerSettings.HostProperty("", "any");
        }
        if (this.selectedRadioButton.isSelected()) {
            return new HttpServerSettings.HostProperty(this.grantTextArea.getText(), "local");
        }
        throw new IllegalStateException();
    }

    public HelpCtx getHelpCtx() {
        String string = HostPropertyCustomEditor.class.getName() + "_properties";
        return new HelpCtx(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }
}

