/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.railsprojects.ui.TreeRootNode;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class SourceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        RailsProject railsProject = (RailsProject)((Object)project.getLookup().lookup(RailsProject.class));
        assert (railsProject != null);
        return new SourcesNodeList(railsProject);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(SourceNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Generator generator, Project project) {
            super((Node)new RootNode(sourceGroup, generator));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (this.actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    this.actions = new Action[actionArray.length + 2];
                    System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                    this.actions[actionArray.length] = null;
                    this.actions[actionArray.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(bl);
        }
    }

    private static final class RootNode
    extends FilterNode {
        private SourceGroup sourceGroup;

        private RootNode(SourceGroup sourceGroup, Generator generator) {
            super(RootNode.getOriginalNode(sourceGroup, generator));
            this.sourceGroup = sourceGroup;
        }

        private static Node getOriginalNode(SourceGroup sourceGroup, Generator generator) {
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF, Lookups.singleton((Object)Generator.NONE));
            }
            return new TreeRootNode(sourceGroup, generator);
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;
        public final Generator generator;

        SourceGroupKey(SourceGroup sourceGroup, Generator generator) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
            this.generator = generator;
        }

        SourceGroupKey(FileObject fileObject) {
            this.group = null;
            this.fileObject = fileObject;
            this.generator = Generator.NONE;
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            String string;
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            String string2 = this.group == null ? null : this.group.getDisplayName();
            String string3 = string = sourceGroupKey.group == null ? null : sourceGroupKey.group.getDisplayName();
            return this.fileObject.equals(sourceGroupKey.fileObject) && (string2 == null ? string == null : string2.equals(string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private RailsProject project;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        public SourcesNodeList(RailsProject railsProject) {
            this.project = railsProject;
        }

        public List<SourceGroupKey> keys() {
            FileObject[] fileObjectArray;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>(sourceGroupArray.length);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new SourceGroupKey(sourceGroupArray[i], this.getGenerator(sourceGroupArray[i].getName())));
            }
            SourceRoots sourceRoots = this.project.getSourceRoots();
            if (sourceRoots != null && (fileObjectArray = sourceRoots.getExtraFiles()) != null && fileObjectArray.length > 0) {
                for (FileObject fileObject : fileObjectArray) {
                    arrayList.add(new SourceGroupKey(fileObject));
                }
            }
            return arrayList;
        }

        private Generator getGenerator(String string) {
            if (string.equals("app/controllers")) {
                return Generator.CONTROLLER;
            }
            if (string.equals("app/views")) {
                return Generator.CONTROLLER;
            }
            if (string.equals("app/models")) {
                return Generator.MODEL;
            }
            if (string.equals("db")) {
                return Generator.MIGRATION;
            }
            return Generator.NONE;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            SourcesNodeList sourcesNodeList = this;
            synchronized (sourcesNodeList) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            if (sourceGroupKey.group == null) {
                try {
                    if (RakeSupport.isRakeFile((FileObject)sourceGroupKey.fileObject)) {
                        return new RakeSupport.RakeNode(sourceGroupKey.fileObject);
                    }
                    DataObject dataObject = DataObject.find((FileObject)sourceGroupKey.fileObject);
                    return new FilterNode(dataObject.getNodeDelegate());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            return new PackageViewFilterNode(sourceGroupKey.group, sourceGroupKey.generator, (Project)this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

