/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.api.EncodingUtil;

public class EncodingHelper {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";

    public boolean isValidEncoding(String string) {
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public String setDefaultEncoding(String string) {
        int n;
        if (string.startsWith("<?xml") && (n = string.indexOf("?>")) > 0) {
            string = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + string.substring(n + 2);
        }
        return string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void resetEncoding() {
        this.encoding = DEFAULT_ENCODING;
    }

    public String detectEncoding(StyledDocument styledDocument) throws IOException {
        return this.setEncoding(EncodingUtil.detectEncoding((Document)styledDocument));
    }

    public String detectEncoding(InputStream inputStream) throws IOException {
        return this.setEncoding(EncodingUtil.detectEncoding((InputStream)inputStream));
    }

    public String detectEncoding(byte[] byArray) throws IOException {
        return this.detectEncoding(new ByteArrayInputStream(byArray));
    }

    public String setEncoding(String string) {
        if (string == null) {
            return this.encoding;
        }
        if (this.isValidEncoding(string)) {
            this.encoding = string;
        }
        return string;
    }
}

