/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;

public abstract class ItemOptionHelper
implements ActionListener,
Refreshable {
    private final AbstractButton[] buttons;
    private final AbstractButton unmatchedOption;
    private XmlMultiViewDataSynchronizer synchronizer;

    public ItemOptionHelper(XmlMultiViewDataSynchronizer xmlMultiViewDataSynchronizer, ButtonGroup buttonGroup) {
        this.synchronizer = xmlMultiViewDataSynchronizer;
        this.buttons = Collections.list(buttonGroup.getElements()).toArray(new AbstractButton[0]);
        AbstractButton abstractButton = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton abstractButton2 = this.buttons[i];
            abstractButton2.addActionListener(this);
            if (this.getOptionText(abstractButton2) != null) continue;
            abstractButton = abstractButton2;
        }
        this.unmatchedOption = abstractButton;
        this.setOption(this.getItemValue());
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string = this.getOption();
        if (!string.equals(this.getItemValue())) {
            this.setItemValue(this.getOption());
            this.synchronizer.requestUpdateData();
        }
    }

    public void setOption(String string) {
        AbstractButton abstractButton = this.getMatchingButton(string);
        if (abstractButton != null && !abstractButton.isSelected()) {
            abstractButton.setSelected(true);
        }
    }

    private AbstractButton getMatchingButton(String string) {
        AbstractButton abstractButton = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton abstractButton2 = this.buttons[i];
            if (!this.getOptionText(abstractButton2).equals(string)) continue;
            abstractButton = abstractButton2;
            break;
        }
        if (abstractButton == null && this.unmatchedOption != null) {
            abstractButton = this.unmatchedOption;
        }
        return abstractButton;
    }

    private String getOptionText(AbstractButton abstractButton) {
        String string = (String)abstractButton.getClientProperty("prop_fixed_value");
        if (string != null) {
            return string;
        }
        return abstractButton.getText();
    }

    public String getOption() {
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton abstractButton = this.buttons[i];
            if (!abstractButton.isSelected()) continue;
            return this.getOptionText(abstractButton);
        }
        return null;
    }

    public abstract String getItemValue();

    public abstract void setItemValue(String var1);

    public void refresh() {
        this.setOption(this.getItemValue());
    }
}

