/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceProvider;
import org.openide.filesystems.FileObject;

public final class PositionConverter {
    private FileObject fo;
    private JavaFileFilterImplementation filter;
    private int offset;
    private int length;
    private JTextComponent component;

    PositionConverter(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation) {
        this.fo = fileObject;
        this.filter = javaFileFilterImplementation;
    }

    PositionConverter(FileObject fileObject, int n, int n2, JTextComponent jTextComponent) {
        this.fo = fileObject;
        this.offset = n;
        this.length = n2;
        this.component = jTextComponent;
        this.filter = new Filter();
    }

    public int getOriginalPosition(int n) {
        if (this.filter instanceof JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation) {
            return ((JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation)this.filter).getOriginalPosition(n);
        }
        return n;
    }

    public int getJavaSourcePosition(int n) {
        if (this.filter instanceof JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation) {
            return ((JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation)this.filter).getJavaSourcePosition(n);
        }
        return n;
    }

    JavaFileFilterImplementation getFilter() {
        return this.filter;
    }

    FileObject getFileObject() {
        return this.fo;
    }

    private class Filter
    implements JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation,
    DocumentListener {
        CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

        public Filter() {
            PositionConverter.this.component.getDocument().addDocumentListener(this);
        }

        public Reader filterReader(final Reader reader) {
            return new Reader(){
                private int next = 0;
                private String text;
                {
                    this.text = Filter.this.convert(PositionConverter.this.component.getText());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int read(char[] cArray, int n, int n2) throws IOException {
                    Object object = this.lock;
                    synchronized (object) {
                        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (n2 == 0) {
                            return 0;
                        }
                        if (this.text.length() == 0 && PositionConverter.this.length == 0) {
                            return reader.read(cArray, n, n2);
                        }
                        if (this.next < PositionConverter.this.offset) {
                            int n3 = reader.read(cArray, n, Math.min(PositionConverter.this.offset - this.next, n2));
                            this.next += n3;
                            return n3;
                        }
                        if (this.next == PositionConverter.this.offset) {
                            reader.skip(PositionConverter.this.length);
                        }
                        if (this.next < PositionConverter.this.offset + this.text.length()) {
                            int n4 = Math.min(PositionConverter.this.offset + this.text.length() - this.next, n2);
                            this.text.getChars(this.next - PositionConverter.this.offset, this.next - PositionConverter.this.offset + n4, cArray, n);
                            this.next += n4;
                            return n4;
                        }
                        return reader.read(cArray, n, n2);
                    }
                }

                public void close() throws IOException {
                    reader.close();
                }
            };
        }

        public CharSequence filterCharSequence(CharSequence charSequence) {
            return charSequence.subSequence(0, PositionConverter.this.offset) + this.convert(PositionConverter.this.component.getText()) + charSequence.subSequence(PositionConverter.this.offset + PositionConverter.this.length, charSequence.length());
        }

        public Writer filterWriter(Writer writer) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.addIfAbsent(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public int getOriginalPosition(int n) {
            if (n < PositionConverter.this.offset) {
                return -1;
            }
            int n2 = n - PositionConverter.this.offset;
            return n2 <= this.convert(PositionConverter.this.component.getText()).length() ? n2 : -1;
        }

        public int getJavaSourcePosition(int n) {
            return PositionConverter.this.offset + n;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(null);
            }
        }

        private String convert(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\r') {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\n') continue;
                    stringBuilder.append('\n');
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }
}

