/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JMapFormat;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaDataLoader
extends MultiFileLoader {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    public static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_INFO = "package-info";
    static final long serialVersionUID = -6286836352608877232L;

    public JavaDataLoader() {
        super("org.netbeans.modules.java.JavaDataObject");
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(JavaDataLoader.class, (String)"PROP_JavaLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        if (fileObject.getExt().equals(JAVA_EXTENSION)) {
            return new JavaDataObject(fileObject, this);
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getAttribute("template") != null && fileObject.getAttribute("javax.script.ScriptEngine") != null) {
            return null;
        }
        if (fileObject.getExt().equals(JAVA_EXTENSION)) {
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        if (JAVA_EXTENSION.equals(fileObject.getExt())) {
            return JavaDataSupport.createJavaFileEntry(multiDataObject, fileObject);
        }
        return new FileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        ErrorManager.getDefault().log("Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(multiDataObject, fileObject);
    }

    static Map<String, String> createStringsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("USER", System.getProperty("user.name"));
        Date date = new Date();
        hashMap.put("DATE", DateFormat.getDateInstance(1).format(date));
        hashMap.put("TIME", DateFormat.getTimeInstance(3).format(date));
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaFileEntry
    extends IndentFileEntry {
        static final long serialVersionUID = 8244159045498569616L;

        public JavaFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            Map<String, String> map = JavaDataLoader.createStringsMap();
            this.modifyMap(map, fileObject, string, string2);
            JMapFormat jMapFormat = new JMapFormat(map);
            jMapFormat.setLeftBrace("__");
            jMapFormat.setRightBrace("__");
            jMapFormat.setCondDelimiter("$");
            jMapFormat.setExactMatch(false);
            return jMapFormat;
        }

        protected void modifyMap(Map<String, String> map, FileObject fileObject, String string, String string2) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string3 = "";
            if (classPath != null) {
                string3 = classPath.getResourceName(fileObject);
            } else {
                ErrorManager.getDefault().log(16, "No classpath was found for folder: " + fileObject);
            }
            map.put("NAME", string);
            map.put("PACKAGE", string3.replace('/', '.'));
            map.put("PACKAGE_SLASHES", string3);
            if (fileObject.isRoot()) {
                map.put("PACKAGE_AND_NAME", string);
                map.put("PACKAGE_AND_NAME_SLASHES", string);
            } else {
                map.put("PACKAGE_AND_NAME", string3.replace('/', '.') + '.' + string);
                map.put("PACKAGE_AND_NAME_SLASHES", string3 + '/' + string);
            }
            map.put("QUOTES", "\"");
            for (CreateFromTemplateAttributesProvider createFromTemplateAttributesProvider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Object v;
                Map map2 = createFromTemplateAttributesProvider.attributesFor((DataObject)this.getDataObject(), DataFolder.findFolder((FileObject)fileObject), string);
                if (map2 == null || !((v = map2.get("user")) instanceof String)) continue;
                map.put("USER", (String)v);
                break;
            }
        }

        public FileObject rename(String string) throws IOException {
            if (!JavaDataLoader.PACKAGE_INFO.equals(string) && !Utilities.isJavaIdentifier((String)string)) {
                throw new IOException(NbBundle.getMessage(JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
            }
            FileObject fileObject = super.rename(string);
            return fileObject;
        }

        @Override
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            Logger.getLogger(JavaDataLoader.class.getName()).warning("Please replace template " + this.getFile().toString() + " with the new scripting support. See " + "http://www.netbeans.org/download/dev/javadoc/org-openide-loaders/apichanges.html#scripting");
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)fileObject.getName(), (String)JavaDataLoader.JAVA_EXTENSION);
            } else if (!JavaDataLoader.PACKAGE_INFO.equals(string) && !Utilities.isJavaIdentifier((String)string)) {
                throw new IOException(NbBundle.getMessage(JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
            }
            this.initializeIndentEngine();
            FileObject fileObject2 = super.createFromTemplate(fileObject, string);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
            String string2 = classPath != null ? classPath.getResourceName(fileObject, '.', false) : "";
            JavaDataObject.renameFO(fileObject2, string2, string, this.getFile().getName());
            this.destroyDataObject(fileObject2);
            return fileObject2;
        }

        private void destroyDataObject(FileObject fileObject) throws IOException {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            try {
                dataObject.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw (IOException)new IOException().initCause(propertyVetoException);
            }
        }
    }
}

