/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.model.LazyTreeLoader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class TreeLoader
extends LazyTreeLoader {
    private static final Logger LOGGER = Logger.getLogger(TreeLoader.class.getName());
    public static boolean DISABLE_CONFINEMENT_TEST = false;
    private Context context;
    private ClasspathInfo cpInfo;
    private Map<Symbol.ClassSymbol, StringBuilder> couplingErrors;
    private boolean partialReparse;

    public static void preRegister(Context context, ClasspathInfo classpathInfo) {
        context.put(lazyTreeLoaderKey, new TreeLoader(context, classpathInfo));
    }

    public static TreeLoader instance(Context context) {
        LazyTreeLoader lazyTreeLoader = LazyTreeLoader.instance((Context)context);
        return lazyTreeLoader instanceof TreeLoader ? (TreeLoader)lazyTreeLoader : null;
    }

    private TreeLoader(Context context, ClasspathInfo classpathInfo) {
        this.context = context;
        this.cpInfo = classpathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadTreeFor(Symbol.ClassSymbol classSymbol, boolean bl) {
        assert (DISABLE_CONFINEMENT_TEST || JavaSourceAccessor.getINSTANCE().isJavaCompilerLocked());
        if (classSymbol == null) return false;
        try {
            Iterator<Map.Entry<Symbol.ClassSymbol, StringBuilder>> iterator;
            boolean bl2;
            FileObject fileObject = SourceUtils.getFile(classSymbol, this.cpInfo);
            JavacTaskImpl javacTaskImpl = this.context.get(JavacTaskImpl.class);
            if (fileObject == null) return false;
            if (javacTaskImpl == null) return false;
            Log.instance((Context)this.context).nerrors = 0;
            SourceFileObject sourceFileObject = FileObjects.nbFileObject(fileObject, null);
            Map<Symbol.ClassSymbol, StringBuilder> map = this.couplingErrors;
            try {
                this.couplingErrors = new HashMap<Symbol.ClassSymbol, StringBuilder>();
                javacTaskImpl.analyze(javacTaskImpl.enter(javacTaskImpl.parse(new JavaFileObject[]{sourceFileObject})));
                if (bl) {
                    this.dumpSymFile(javacTaskImpl, classSymbol);
                }
                bl2 = true;
                Object var9_9 = null;
                iterator = this.couplingErrors.entrySet().iterator();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Iterator<Map.Entry<Symbol.ClassSymbol, StringBuilder>> iterator2 = this.couplingErrors.entrySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        this.couplingErrors = map;
                        throw throwable;
                    }
                    Map.Entry<Symbol.ClassSymbol, StringBuilder> entry = iterator2.next();
                    this.logCouplingError(entry.getKey(), entry.getValue().toString());
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    this.couplingErrors = map;
                    return bl2;
                }
                Map.Entry<Symbol.ClassSymbol, StringBuilder> entry = iterator.next();
                this.logCouplingError(entry.getKey(), entry.getValue().toString());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    public final void startPartialReparse() {
        this.partialReparse = true;
    }

    public final void endPartialReparse() {
        this.partialReparse = false;
    }

    public void couplingError(Symbol.ClassSymbol classSymbol, Tree tree) {
        if (this.partialReparse) {
            throw new CouplingAbort(classSymbol.classfile, tree);
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        switch (tree.getKind()) {
            case CLASS: {
                stringBuilder.append("CLASS: ").append(((ClassTree)tree).getSimpleName().toString());
                break;
            }
            case VARIABLE: {
                stringBuilder.append("VARIABLE: ").append(((VariableTree)tree).getName().toString());
                break;
            }
            case METHOD: {
                stringBuilder.append("METHOD: ").append(((MethodTree)tree).getName().toString());
                break;
            }
            case TYPE_PARAMETER: {
                stringBuilder.append("TYPE_PARAMETER: ").append(((TypeParameterTree)tree).getName().toString());
                break;
            }
            default: {
                stringBuilder.append("TREE: <unknown>");
            }
        }
        if (classSymbol != null && this.couplingErrors != null) {
            StringBuilder stringBuilder2 = this.couplingErrors.get(classSymbol);
            if (stringBuilder2 != null) {
                stringBuilder2.append((CharSequence)stringBuilder);
            } else {
                this.couplingErrors.put(classSymbol, stringBuilder);
            }
        } else {
            this.logCouplingError(classSymbol, stringBuilder.toString());
        }
    }

    private void logCouplingError(Symbol.ClassSymbol classSymbol, String string) {
        JavaFileObject javaFileObject = classSymbol != null ? classSymbol.classfile : null;
        String string2 = javaFileObject != null ? javaFileObject.toUri().toASCIIString() : "<unknown>";
        JavaFileObject javaFileObject2 = classSymbol != null ? classSymbol.sourcefile : null;
        String string3 = javaFileObject != null ? javaFileObject2.toUri().toASCIIString() : "<unknown>";
        LOGGER.log(Level.WARNING, "Coupling error:\nclass file: {0}\nsource file: {1}{2}\n", new Object[]{string2, string3, string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpSymFile(JavacTaskImpl javacTaskImpl, Symbol.ClassSymbol classSymbol) throws IOException {
        Env<AttrContext> env = Enter.instance(this.context).getEnv(classSymbol);
        if (env == null) {
            return;
        }
        new TreeScanner(){

            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                super.visitMethodDef(jCMethodDecl);
                jCMethodDecl.body = null;
            }

            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                super.visitVarDef(jCVariableDecl);
                jCVariableDecl.init = null;
            }

            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.scan(jCClassDecl.mods);
                this.scan(jCClassDecl.typarams);
                this.scan(jCClassDecl.extending);
                this.scan(jCClassDecl.implementing);
                if (jCClassDecl.defs != null) {
                    List<JCTree> list = null;
                    List<JCTree> list2 = jCClassDecl.defs;
                    while (list2.nonEmpty()) {
                        this.scan((JCTree)list2.head);
                        if (((JCTree)list2.head).getTag() == 7 && ((JCTree.JCBlock)list2.head).isStatic()) {
                            if (list != null) {
                                list.tail = list2.tail;
                            } else {
                                jCClassDecl.defs = list2.tail;
                            }
                        }
                        list = list2;
                        list2 = list2.tail;
                    }
                }
            }
        }.scan(env.toplevel);
        JavaFileManager javaFileManager = ClasspathInfoAccessor.getINSTANCE().getFileManager(this.cpInfo);
        try {
            String string = null;
            if (classSymbol.classfile != null) {
                string = javaFileManager.inferBinaryName(StandardLocation.PLATFORM_CLASS_PATH, classSymbol.classfile);
                if (string == null) {
                    string = javaFileManager.inferBinaryName(StandardLocation.CLASS_PATH, classSymbol.classfile);
                }
            } else if (classSymbol.sourcefile != null) {
                string = javaFileManager.inferBinaryName(StandardLocation.SOURCE_PATH, classSymbol.sourcefile);
            }
            if (string == null) {
                Object var10_6 = null;
                javaFileManager.handleOption("output-root", Collections.singletonList("").iterator());
                return;
            }
            String string2 = classSymbol.classfile.toUri().toURL().toExternalForm();
            int n = string2.lastIndexOf(FileObjects.convertPackage2Folder(string));
            assert (n > 0);
            File file = Index.getClassFolder(new URL(string2.substring(0, n)));
            javaFileManager.handleOption("output-root", Collections.singletonList(file.getPath()).iterator());
            javacTaskImpl.generate(Collections.singletonList(classSymbol));
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            javaFileManager.handleOption("output-root", Collections.singletonList("").iterator());
            throw throwable;
        }
        Object var10_7 = null;
        javaFileManager.handleOption("output-root", Collections.singletonList("").iterator());
    }
}

