/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.source.tasklist.TasklistOptionsPanel;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class TaskListOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private TasklistOptionsPanel panel;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void update() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.panel == null) {
            this.getComponent(null);
        }
        this.panel.setDependenciesEnabled(TasklistSettings.isDependencyTrackingEnabled());
        this.panel.setBadgesEnabled(TasklistSettings.isBadgesEnabled());
        this.panel.setTasklistEnabled(TasklistSettings.isTasklistEnabled());
    }

    public void applyChanges() {
        if (this.panel == null) {
            return;
        }
        TasklistSettings.setTasklistsEnabled(this.panel.getTasklistEnabled());
        TasklistSettings.setDependencyTrackingEnabled(this.panel.getDependenciesEnabled());
        TasklistSettings.setBadgesEnabled(this.panel.getBadgesEnabled());
    }

    public void cancel() {
        if (this.panel == null) {
            return;
        }
        this.panel.setTasklistEnabled(TasklistSettings.isTasklistEnabled());
        this.panel.setDependenciesEnabled(TasklistSettings.isDependencyTrackingEnabled());
        this.panel.setBadgesEnabled(TasklistSettings.isBadgesEnabled());
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.panel == null) {
            return false;
        }
        return TasklistSettings.isTasklistEnabled() != this.panel.getTasklistEnabled() || TasklistSettings.isDependencyTrackingEnabled() != this.panel.getDependenciesEnabled() || TasklistSettings.isBadgesEnabled() != this.panel.getBadgesEnabled();
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new TasklistOptionsPanel();
            this.panel.addChangeListener(this);
        }
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.java.tasklist");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.pcs.firePropertyChange("changed", null, null);
    }
}

