/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.util.prefs.Preferences;
import org.netbeans.modules.java.source.tasklist.ErrorAnnotator;
import org.netbeans.modules.java.source.tasklist.JavaTaskProvider;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.util.NbPreferences;

public class TasklistSettings {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_ERROR_BADGES = "error-badges";
    private static final String KEY_DEPENDENCY_TRACKING = "dependency-tracking";
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_ERROR_BADGES = true;
    private static final boolean DEFAULT_DEPENDENCY_TRACKING = true;

    private TasklistSettings() {
    }

    public static boolean isTasklistEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_ENABLED, true);
    }

    public static void setTasklistsEnabled(boolean bl) {
        if (TasklistSettings.isTasklistEnabled() != bl) {
            ErrorAnnotator errorAnnotator;
            TasklistSettings.getPreferencesNode().putBoolean(KEY_ENABLED, bl);
            if (bl) {
                RepositoryUpdater.getDefault().rebuildAll(true);
            }
            if ((errorAnnotator = ErrorAnnotator.getAnnotator()) != null) {
                errorAnnotator.updateAllInError();
            }
            JavaTaskProvider.refreshAll();
        }
    }

    public static boolean isBadgesEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_ERROR_BADGES, true);
    }

    public static void setBadgesEnabled(boolean bl) {
        if (TasklistSettings.isBadgesEnabled() != bl) {
            TasklistSettings.getPreferencesNode().putBoolean(KEY_ERROR_BADGES, bl);
            ErrorAnnotator errorAnnotator = ErrorAnnotator.getAnnotator();
            if (errorAnnotator != null) {
                errorAnnotator.updateAllInError();
            }
        }
    }

    public static boolean isDependencyTrackingEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_DEPENDENCY_TRACKING, true);
    }

    public static void setDependencyTrackingEnabled(boolean bl) {
        if (TasklistSettings.isDependencyTrackingEnabled() != bl) {
            ErrorAnnotator errorAnnotator;
            TasklistSettings.getPreferencesNode().putBoolean(KEY_DEPENDENCY_TRACKING, bl);
            if (bl) {
                RepositoryUpdater.getDefault().rebuildAll(true);
            }
            if ((errorAnnotator = ErrorAnnotator.getAnnotator()) != null) {
                errorAnnotator.updateAllInError();
            }
        }
    }

    private static Preferences getPreferencesNode() {
        return NbPreferences.forModule(TasklistSettings.class).node("tasklist");
    }
}

