/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.java.source.usages.BytecodeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileUtil {
    private static final Set<ElementKind> TYPE_DECLS = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
    static char[] nameChars = new char[512];

    private ClassFileUtil() {
    }

    public static boolean accessesFiledOrMethod(String[] stringArray, String[] stringArray2, Code code, ConstantPool constantPool) {
        BytecodeDecoder bytecodeDecoder = new BytecodeDecoder(code.getByteCodes());
        block4: for (byte[] byArray : bytecodeDecoder) {
            switch (byArray[0] & 0xFF) {
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    if (stringArray == null) break;
                    int n = BytecodeDecoder.toInt(byArray[1], byArray[2]);
                    CPFieldInfo cPFieldInfo = (CPFieldInfo)constantPool.get(n);
                    String string = cPFieldInfo.getClassName().getInternalName();
                    String string2 = cPFieldInfo.getFieldName();
                    String string3 = cPFieldInfo.getDescriptor();
                    if (!stringArray[0].equals(string) || stringArray[1] != null && (!stringArray[1].equals(string2) || !stringArray[2].equals(string3))) continue block4;
                    return true;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    if (stringArray2 == null) break;
                    int n = BytecodeDecoder.toInt(byArray[1], byArray[2]);
                    CPFieldInfo cPFieldInfo = (CPMethodInfo)constantPool.get(n);
                    String string = cPFieldInfo.getClassName().getInternalName();
                    String string2 = cPFieldInfo.getMethodName();
                    String string3 = cPFieldInfo.getDescriptor();
                    if (!stringArray2[0].equals(string) || stringArray2[1] != null && (!stringArray2[1].equals(string2) || !stringArray2[2].equals(string3))) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean accessesFiledOrMethod(String[] stringArray, String[] stringArray2, Method method) {
        Code code = method.getCode();
        if (code != null) {
            ConstantPool constantPool = method.getClassFile().getConstantPool();
            return ClassFileUtil.accessesFiledOrMethod(stringArray, stringArray2, code, constantPool);
        }
        return false;
    }

    public static <T extends Method> Collection<T> accessesFiled(String[] stringArray, Collection<T> collection) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : collection) {
            if (!ClassFileUtil.accessesFiledOrMethod(stringArray, null, method)) continue;
            linkedList.add(method);
        }
        return linkedList;
    }

    public static <T extends Method> Collection<T> callsMethod(String[] stringArray, Collection<T> collection) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : collection) {
            if (!ClassFileUtil.accessesFiledOrMethod(null, stringArray, method)) continue;
            linkedList.add(method);
        }
        return linkedList;
    }

    public static String[] createFieldDescriptor(VariableElement variableElement) {
        assert (variableElement != null);
        String[] stringArray = new String[3];
        Element element = variableElement.getEnclosingElement();
        assert (element instanceof TypeElement);
        stringArray[0] = ClassFileUtil.encodeClassNameOrArray((TypeElement)element);
        stringArray[1] = variableElement.getSimpleName().toString();
        StringBuilder stringBuilder = new StringBuilder();
        ClassFileUtil.encodeType(variableElement.asType(), stringBuilder);
        stringArray[2] = stringBuilder.toString();
        return stringArray;
    }

    public static String[] createExecutableDescriptor(ExecutableElement executableElement) {
        assert (executableElement != null);
        ElementKind elementKind = executableElement.getKind();
        String[] stringArray = elementKind == ElementKind.STATIC_INIT || elementKind == ElementKind.INSTANCE_INIT ? new String[2] : new String[3];
        Element element = executableElement.getEnclosingElement();
        assert (element instanceof TypeElement);
        stringArray[0] = ClassFileUtil.encodeClassNameOrArray((TypeElement)element);
        if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
            StringBuilder stringBuilder = new StringBuilder();
            if (elementKind == ElementKind.METHOD) {
                stringArray[1] = executableElement.getSimpleName().toString();
                ClassFileUtil.encodeType(executableElement.getReturnType(), stringBuilder);
            } else {
                stringArray[1] = "<init>";
                stringBuilder.append('V');
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append('(');
            for (VariableElement variableElement : executableElement.getParameters()) {
                ClassFileUtil.encodeType(variableElement.asType(), stringBuilder2);
            }
            stringBuilder2.append(')');
            stringBuilder2.append((CharSequence)stringBuilder);
            stringArray[2] = stringBuilder2.toString();
        } else if (elementKind == ElementKind.INSTANCE_INIT) {
            stringArray[1] = "<init>";
        } else if (elementKind == ElementKind.STATIC_INIT) {
            stringArray[1] = "<cinit>";
        } else {
            throw new IllegalArgumentException();
        }
        return stringArray;
    }

    public static String encodeClassNameOrArray(TypeElement typeElement) {
        assert (typeElement != null);
        javax.lang.model.element.Name name = typeElement.getQualifiedName();
        TypeMirror typeMirror = typeElement.getEnclosingElement().asType();
        if (name != null && typeMirror != null && typeMirror.getKind() == TypeKind.NONE && "Array".equals(name.toString())) {
            return "[";
        }
        return ClassFileUtil.encodeClassName(typeElement);
    }

    public static String encodeClassName(TypeElement typeElement) {
        assert (typeElement != null);
        StringBuilder stringBuilder = new StringBuilder();
        ClassFileUtil.encodeClassName(typeElement, stringBuilder, '.');
        return stringBuilder.toString();
    }

    private static void encodeType(TypeMirror typeMirror, StringBuilder stringBuilder) {
        switch (typeMirror.getKind()) {
            case VOID: {
                stringBuilder.append('V');
                break;
            }
            case BOOLEAN: {
                stringBuilder.append('Z');
                break;
            }
            case BYTE: {
                stringBuilder.append('B');
                break;
            }
            case SHORT: {
                stringBuilder.append('S');
                break;
            }
            case INT: {
                stringBuilder.append('I');
                break;
            }
            case LONG: {
                stringBuilder.append('J');
                break;
            }
            case CHAR: {
                stringBuilder.append('C');
                break;
            }
            case FLOAT: {
                stringBuilder.append('F');
                break;
            }
            case DOUBLE: {
                stringBuilder.append('D');
                break;
            }
            case ARRAY: {
                stringBuilder.append('[');
                assert (typeMirror instanceof ArrayType);
                ClassFileUtil.encodeType(((ArrayType)typeMirror).getComponentType(), stringBuilder);
                break;
            }
            case DECLARED: {
                stringBuilder.append('L');
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                ClassFileUtil.encodeClassName(typeElement, stringBuilder, '/');
                stringBuilder.append(';');
                break;
            }
            case TYPEVAR: {
                assert (typeMirror instanceof TypeVariable);
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                TypeMirror typeMirror2 = typeVariable.getUpperBound();
                if (typeMirror2.getKind() == TypeKind.NULL) {
                    stringBuilder.append("Ljava/lang/Object;");
                    break;
                }
                ClassFileUtil.encodeType(typeMirror2, stringBuilder);
                break;
            }
            case ERROR: {
                TypeElement typeElement = (TypeElement)((ErrorType)typeMirror).asElement();
                if (typeElement != null) {
                    stringBuilder.append('L');
                    ClassFileUtil.encodeClassName(typeElement, stringBuilder, '/');
                    stringBuilder.append(';');
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void encodeClassName(TypeElement typeElement, StringBuilder stringBuilder, char c) {
        Name name = ((Symbol.ClassSymbol)typeElement).flatname;
        assert (name != null);
        int n = name.len;
        if (nameChars.length < n) {
            nameChars = new char[n];
        }
        int n2 = Convert.utf2chars((byte[])name.table.names, (int)name.index, (char[])nameChars, (int)0, (int)n);
        if (c != '.') {
            for (int i = 0; i < n2; ++i) {
                if (nameChars[i] != '.') continue;
                ClassFileUtil.nameChars[i] = c;
            }
        }
        stringBuilder.append(nameChars, 0, n2);
    }

    public static ClassName getType(String string) {
        if (string.length() < 2) {
            return null;
        }
        if (string.charAt(0) == 'L') {
            return ClassName.getClassName((String)string);
        }
        if (string.charAt(0) == '[') {
            return ClassFileUtil.getType(string.substring(1));
        }
        return null;
    }

    public static ClassName getType(CPClassInfo cPClassInfo) {
        String string = cPClassInfo.getName();
        if (string.charAt(0) == '[') {
            return ClassFileUtil.getType(string);
        }
        return cPClassInfo.getClassName();
    }

    public static ClassName[] getTypesFromMethodTypeSignature(String string) {
        HashSet<ClassName> hashSet = new HashSet<ClassName>();
        ClassFileUtil.methodTypeSignature(string, new int[]{0}, hashSet);
        return hashSet.toArray(new ClassName[hashSet.size()]);
    }

    public static ClassName[] getTypesFromFiledTypeSignature(String string) {
        HashSet<ClassName> hashSet = new HashSet<ClassName>();
        ClassFileUtil.typeSignatureType(string, new int[]{0}, hashSet, false);
        return hashSet.toArray(new ClassName[hashSet.size()]);
    }

    public static ClassName[] getTypesFromClassTypeSignature(String string) {
        HashSet<ClassName> hashSet = new HashSet<ClassName>();
        ClassFileUtil.classTypeSignature(string, new int[]{0}, hashSet);
        return hashSet.toArray(new ClassName[hashSet.size()]);
    }

    private static char getChar(String string, int n) {
        if (n >= string.length()) {
            throw new IllegalStateException();
        }
        return string.charAt(n);
    }

    private static void classTypeSignature(String string, int[] nArray, Set<ClassName> set) {
        char c = ClassFileUtil.getChar(string, nArray[0]);
        if (c == '<') {
            ClassFileUtil.formalTypeParameters(string, nArray, set);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        ClassFileUtil.typeSignatureType(string, nArray, set, false);
        while (nArray[0] < string.length()) {
            ClassFileUtil.typeSignatureType(string, nArray, set, false);
        }
    }

    private static void methodTypeSignature(String string, int[] nArray, Set<ClassName> set) {
        char c = ClassFileUtil.getChar(string, nArray[0]);
        if (c == '<') {
            ClassFileUtil.formalTypeParameters(string, nArray, set);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        if (c != '(') {
            throw new IllegalStateException(string);
        }
        nArray[0] = nArray[0] + 1;
        c = ClassFileUtil.getChar(string, nArray[0]);
        while (c != ')') {
            ClassFileUtil.typeSignatureType(string, nArray, set, false);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        nArray[0] = nArray[0] + 1;
        ClassFileUtil.typeSignatureType(string, nArray, set, false);
    }

    private static void formalTypeParam(String string, int[] nArray, Set<ClassName> set) {
        int n;
        char c;
        do {
            n = nArray[0];
            nArray[0] = n + 1;
        } while ((c = ClassFileUtil.getChar(string, n)) != ':');
        c = ClassFileUtil.getChar(string, nArray[0]);
        if (c != ':') {
            ClassFileUtil.typeSignatureType(string, nArray, set, true);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        while (c == ':') {
            nArray[0] = nArray[0] + 1;
            ClassFileUtil.typeSignatureType(string, nArray, set, true);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
    }

    private static void formalTypeParameters(String string, int[] nArray, Set<ClassName> set) {
        int n = nArray[0];
        nArray[0] = n + 1;
        char c = ClassFileUtil.getChar(string, n);
        if (c != '<') {
            throw new IllegalArgumentException(string);
        }
        c = ClassFileUtil.getChar(string, nArray[0]);
        while (c != '>') {
            ClassFileUtil.formalTypeParam(string, nArray, set);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        nArray[0] = nArray[0] + 1;
    }

    private static void typeArgument(String string, int[] nArray, Set<ClassName> set) {
        char c = ClassFileUtil.getChar(string, nArray[0]);
        if (c == '*') {
            nArray[0] = nArray[0] + 1;
            return;
        }
        if (c == '+' || c == '-') {
            nArray[0] = nArray[0] + 1;
            ClassFileUtil.typeSignatureType(string, nArray, set, true);
        } else {
            ClassFileUtil.typeSignatureType(string, nArray, set, true);
        }
    }

    private static void typeArgumentsList(String string, int[] nArray, Set<ClassName> set) {
        int n = nArray[0];
        nArray[0] = n + 1;
        char c = ClassFileUtil.getChar(string, n);
        if (c != '<') {
            throw new IllegalStateException(string);
        }
        c = ClassFileUtil.getChar(string, nArray[0]);
        while (c != '>') {
            ClassFileUtil.typeArgument(string, nArray, set);
            c = ClassFileUtil.getChar(string, nArray[0]);
        }
        nArray[0] = nArray[0] + 1;
    }

    private static void typeSignatureType(String string, int[] nArray, Set<ClassName> set, boolean bl) {
        int n = nArray[0];
        nArray[0] = n + 1;
        char c = ClassFileUtil.getChar(string, n);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                break;
            }
            case 'L': {
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    stringBuilder.append(c);
                    c = ClassFileUtil.getChar(string, nArray[0]);
                    if (c == '<') {
                        ClassFileUtil.typeArgumentsList(string, nArray, set);
                        int n2 = nArray[0];
                        nArray[0] = n2 + 1;
                        c = ClassFileUtil.getChar(string, n2);
                        continue;
                    }
                    nArray[0] = nArray[0] + 1;
                } while (c != ';');
                stringBuilder.append(c);
                if (!bl) break;
                set.add(ClassName.getClassName((String)stringBuilder.toString()));
                break;
            }
            case 'T': {
                int n3;
                do {
                    n3 = nArray[0];
                    nArray[0] = n3 + 1;
                } while ((c = ClassFileUtil.getChar(string, n3)) != ';');
                break;
            }
            case '[': {
                ClassFileUtil.typeSignatureType(string, nArray, set, bl);
            }
        }
    }
}

