/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.bookmarks.BookmarksApiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.openide.cookies.EditorCookie;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public final class ToggleBookmarkAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Toolbar {
    private static final String ACTION_NAME = "bookmark-toggle";
    private static final String ACTION_ICON = "org/netbeans/modules/editor/bookmarks/resources/toggle_bookmark.png";
    private final JTextComponent component;

    public ToggleBookmarkAction() {
        this((JTextComponent)null);
    }

    public ToggleBookmarkAction(JTextComponent jTextComponent) {
        super(NbBundle.getMessage(ToggleBookmarkAction.class, (String)ACTION_NAME), new ImageIcon(Utilities.loadImage((String)ACTION_ICON)));
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.component = jTextComponent;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        JTextComponent jTextComponent = ToggleBookmarkAction.findComponent(lookup);
        return new ToggleBookmarkAction(jTextComponent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.component != null) {
            ToggleBookmarkAction.actionPerformed(this.component);
        } else {
            JTextComponent jTextComponent = ToggleBookmarkAction.findComponent(Utilities.actionsGlobalContext());
            if (jTextComponent != null) {
                ToggleBookmarkAction.actionPerformed(jTextComponent);
            }
        }
    }

    public boolean isEnabled() {
        if (this.component != null) {
            return true;
        }
        JTextComponent jTextComponent = ToggleBookmarkAction.findComponent(Utilities.actionsGlobalContext());
        return jTextComponent != null;
    }

    public Component getToolbarPresenter() {
        AbstractButton abstractButton;
        if (this.component != null) {
            abstractButton = new MyGaGaButton();
            abstractButton.setModel(new BookmarkButtonModel(this.component));
        } else {
            abstractButton = new JButton();
        }
        abstractButton.putClientProperty("hideActionText", Boolean.TRUE);
        abstractButton.setAction(this);
        return abstractButton;
    }

    private static JTextComponent findComponent(Lookup lookup) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private static void actionPerformed(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (org.netbeans.editor.Utilities.getEditorUI((JTextComponent)jTextComponent).isGlyphGutterVisible()) {
                Caret caret = jTextComponent.getCaret();
                BookmarkList bookmarkList = BookmarkList.get(jTextComponent.getDocument());
                bookmarkList.toggleLineBookmark(caret.getDot());
            } else {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    private static final class MyGaGaButton
    extends JToggleButton
    implements ChangeListener {
        public void setModel(ButtonModel buttonModel) {
            ButtonModel buttonModel2 = this.getModel();
            if (buttonModel2 != null) {
                buttonModel2.removeChangeListener(this);
            }
            super.setModel(buttonModel);
            ButtonModel buttonModel3 = this.getModel();
            if (buttonModel3 != null) {
                buttonModel3.addChangeListener(this);
            }
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = this.isSelected();
            super.setContentAreaFilled(bl);
            super.setBorderPainted(bl);
        }

        public void setBorderPainted(boolean bl) {
            if (!this.isSelected()) {
                super.setBorderPainted(bl);
            }
        }

        public void setContentAreaFilled(boolean bl) {
            if (!this.isSelected()) {
                super.setContentAreaFilled(bl);
            }
        }
    }

    private static final class BookmarkButtonModel
    extends JToggleButton.ToggleButtonModel
    implements PropertyChangeListener,
    ChangeListener {
        private final JTextComponent component;
        private Caret caret;
        private BookmarkList bookmarks;
        private int lastCurrentLineStartOffset = -1;
        private PropertyChangeListener bookmarksListener = null;
        private ChangeListener caretListener = null;

        public BookmarkButtonModel(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
            this.rebuild();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || "document".equals(propertyChangeEvent.getPropertyName()) || "caret".equals(propertyChangeEvent.getPropertyName())) {
                this.rebuild();
            } else if ("bookmarks".equals(propertyChangeEvent.getPropertyName())) {
                this.lastCurrentLineStartOffset = -1;
                this.updateState();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateState();
        }

        private static boolean isBookmarkOnTheLine(BookmarkList bookmarkList, int n) {
            Bookmark bookmark = bookmarkList.getNextBookmark(n - 1, false);
            return bookmark == null ? false : n == bookmark.getOffset();
        }

        private void rebuild() {
            Caret caret;
            BookmarkList bookmarkList = BookmarkList.get(this.component.getDocument());
            if (bookmarkList != this.bookmarks) {
                if (this.bookmarksListener != null) {
                    BookmarksApiPackageAccessor.get().removeBookmarkListPcl(this.bookmarks, this.bookmarksListener);
                    this.bookmarksListener = null;
                }
                this.bookmarks = bookmarkList;
                if (this.bookmarks != null) {
                    this.bookmarksListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.bookmarks);
                    BookmarksApiPackageAccessor.get().addBookmarkListPcl(this.bookmarks, this.bookmarksListener);
                }
            }
            if ((caret = this.component.getCaret()) != this.caret) {
                if (this.caretListener != null) {
                    this.caret.removeChangeListener(this.caretListener);
                    this.caretListener = null;
                }
                this.caret = caret;
                if (this.caret != null) {
                    this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                    this.caret.addChangeListener(this.caretListener);
                }
            }
            this.lastCurrentLineStartOffset = -1;
            this.updateState();
        }

        private void updateState() {
            Document document = this.component.getDocument();
            if (this.caret != null && this.bookmarks != null && document instanceof BaseDocument) {
                try {
                    int n = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((BaseDocument)document), (int)this.caret.getDot());
                    if (n != this.lastCurrentLineStartOffset) {
                        this.lastCurrentLineStartOffset = n;
                        boolean bl = BookmarkButtonModel.isBookmarkOnTheLine(this.bookmarks, n);
                        this.setSelected(bl);
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.lastCurrentLineStartOffset = -1;
                }
            }
        }
    }
}

