/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksMap;
import org.openide.ErrorManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BookmarksXMLHandler {
    static final String EDITOR_BOOKMARKS_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    static final String EDITOR_BOOKMARKS_ELEM = "editor-bookmarks";
    private static final String FILE_ELEM = "file";
    private static final String URL_ELEM = "url";
    private static final String LINE_ELEM = "line";

    private BookmarksXMLHandler() {
    }

    public static void loadFileBookmarksMap(FileBookmarksMap fileBookmarksMap, Element element, URL uRL) {
        Node node = BookmarksXMLHandler.skipNonElementNode(element.getFirstChild());
        while (node != null) {
            Object object;
            Object object2;
            assert (FILE_ELEM.equals(node.getNodeName()));
            Node node2 = BookmarksXMLHandler.skipNonElementNode(node.getFirstChild());
            assert (URL_ELEM.equals(node2.getNodeName()));
            Node node3 = BookmarksXMLHandler.skipNonElementNode(node2.getNextSibling());
            int[] nArray = new int[1];
            int n = 0;
            while (node3 != null) {
                assert (LINE_ELEM.equals(node3.getNodeName()));
                if (n == nArray.length) {
                    nArray = BookmarksXMLHandler.reallocateIntArray(nArray, n, n << 1);
                }
                try {
                    object2 = node3.getFirstChild();
                    object = object2.getNodeValue();
                    int n2 = Integer.parseInt((String)object);
                    nArray[n++] = n2;
                }
                catch (DOMException dOMException) {
                    ErrorManager.getDefault().notify((Throwable)dOMException);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().notify((Throwable)numberFormatException);
                }
                node3 = BookmarksXMLHandler.skipNonElementNode(node3.getNextSibling());
            }
            try {
                try {
                    object = node2.getFirstChild();
                    String string = object.getNodeValue();
                    URI uRI = new URI(string);
                    object2 = !uRI.isAbsolute() && uRL != null ? new URL(uRL, string) : new URL(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                    object2 = null;
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    object2 = null;
                }
                if (object2 != null) {
                    if (n != nArray.length) {
                        nArray = BookmarksXMLHandler.reallocateIntArray(nArray, n, n);
                    }
                    fileBookmarksMap.put(new FileBookmarks((URL)object2, nArray));
                }
            }
            catch (DOMException dOMException) {
                ErrorManager.getDefault().notify((Throwable)dOMException);
            }
            node = BookmarksXMLHandler.skipNonElementNode(node.getNextSibling());
        }
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    public static Element saveFileBookmarksMap(FileBookmarksMap fileBookmarksMap, URI uRI) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, EDITOR_BOOKMARKS_ELEM);
            for (FileBookmarks fileBookmarks : fileBookmarksMap.all()) {
                if (fileBookmarks.getBookmarkCount() <= 0) continue;
                BookmarksXMLHandler.saveFileBookmarks(fileBookmarks, document, element, uRI);
            }
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            return null;
        }
    }

    private static void saveFileBookmarks(FileBookmarks fileBookmarks, Document document, Element element, URI uRI) throws DOMException {
        Element element2 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, FILE_ELEM);
        Element element3 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, URL_ELEM);
        String string = fileBookmarks.getURL().toExternalForm();
        if (uRI != null) {
            try {
                URI uRI2 = new URI(string);
                URI uRI3 = uRI.relativize(uRI2);
                string = uRI3.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
        }
        element3.appendChild(document.createTextNode(string));
        element2.appendChild(element3);
        int n = fileBookmarks.getBookmarkCount();
        for (int i = 0; i < n; ++i) {
            int n2 = fileBookmarks.getBookmarkLineIndex(i);
            Element element4 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, LINE_ELEM);
            element4.appendChild(document.createTextNode(Integer.toString(n2)));
            element2.appendChild(element4);
        }
        element.appendChild(element2);
    }

    static int[] reallocateIntArray(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }
}

