/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.BookmarksApiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class DocumentUnmodifiedListener
implements PropertyChangeListener {
    private static final Map eco2listener = new WeakHashMap();
    private static final DocumentUnmodifiedListener INSTANCE = new DocumentUnmodifiedListener();

    public static void init(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null) {
            EditorCookie.Observable observable;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                observable = null;
            }
            if (observable != null && eco2listener.get(observable) == null) {
                observable.addPropertyChangeListener((PropertyChangeListener)INSTANCE);
                eco2listener.put(observable, INSTANCE);
            }
        }
    }

    private DocumentUnmodifiedListener() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        EditorCookie.Observable observable;
        StyledDocument styledDocument;
        if ("modified".equals(propertyChangeEvent.getPropertyName()) && !Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && (styledDocument = (observable = (EditorCookie.Observable)propertyChangeEvent.getSource()).getDocument()) != null) {
            BookmarkList bookmarkList = BookmarkList.get(styledDocument);
            BookmarkManager bookmarkManager = BookmarksApiPackageAccessor.get().getBookmarkManager(bookmarkList);
            bookmarkManager.saveBookmarks();
        }
    }
}

