/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hqleditor;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.cfg.AnnotationConfiguration;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.hqleditor.HQLExecutor;
import org.netbeans.modules.hibernate.hqleditor.HQLResult;
import org.netbeans.modules.hibernate.hqleditor.ui.HQLEditorTopComponent;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQLEditorController {
    private Logger logger = Logger.getLogger(HQLEditorController.class.getName());
    HQLEditorTopComponent editorTopComponent = null;

    public void executeHQLQuery(final String string, final FileObject fileObject, final int n, final ProgressHandle progressHandle) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            progressHandle.progress(10);
            progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPrepare"));
            final Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            arrayList.addAll(hibernateEnvironment.getProjectClassPath(fileObject));
            for (FileObject object2 : hibernateEnvironment.getAllHibernateMappingFileObjects()) {
                arrayList.add(object2.getURL());
            }
            final CustomClassLoader customClassLoader = new CustomClassLoader(arrayList.toArray(new URL[0]), this.getClass().getClassLoader());
            Thread thread = new Thread(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(customClassLoader);
                    HQLExecutor hQLExecutor = new HQLExecutor();
                    try {
                        AnnotationConfiguration annotationConfiguration = HQLEditorController.this.processAndConstructCustomConfiguration(string, fileObject, project);
                        progressHandle.progress(50);
                        progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPassControlToHibernate"));
                        HQLResult hQLResult = hQLExecutor.execute(string, annotationConfiguration, n, progressHandle);
                        progressHandle.progress(80);
                        progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionProcessResults"));
                        HQLEditorController.this.editorTopComponent.setResult(hQLResult);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            };
            thread.setContextClassLoader(customClassLoader);
            thread.start();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void init(Node[] nodeArray) {
        this.editorTopComponent = new HQLEditorTopComponent(this);
        this.editorTopComponent.open();
        this.editorTopComponent.requestActive();
        this.editorTopComponent.setFocusToEditor();
        this.editorTopComponent.fillHibernateConfigurations(nodeArray);
    }

    public AnnotationConfiguration getHibernateConfigurationForThisContext(FileObject fileObject, List<FileObject> list, List<Class> list2) {
        AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration();
        for (FileObject object : list) {
            this.logger.info("Adding mapping to custom configuration " + object.getName());
            annotationConfiguration.addFile(FileUtil.toFile((FileObject)object));
        }
        for (Class clazz : list2) {
            this.logger.info("Adding annotated class to custom configuration " + clazz);
            annotationConfiguration.addAnnotatedClass(clazz);
        }
        Properties properties = new Properties();
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(fileObject.getInputStream());
            Element element = document.getRootElement().element("session-factory");
            Iterator iterator = element.elementIterator("property");
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string = element2.attributeValue("name");
                String string2 = element2.getTextTrim();
                properties.setProperty(string, string2);
                if (string2 != null && string2.endsWith("password")) {
                    string2 = "*****";
                }
                this.logger.info("name = " + string + " value= " + string2);
            }
            properties.setProperty("hibernate.mapping.precedence", "class, hbm");
            annotationConfiguration.mergeProperties(properties);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return annotationConfiguration;
    }

    public AnnotationConfiguration processAndConstructCustomConfiguration(String string, FileObject fileObject, Project project) {
        Iterator iterator;
        Object object;
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\f\t(),");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        Map<FileObject, List<String>> map = hibernateEnvironment.getAllPOJONamesFromConfiguration(fileObject);
        for (FileObject object22 : map.keySet()) {
            Object object2;
            object = map.get(object22);
            this.logger.info("pojoNameList from configution : ");
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                this.logger.info("pojo-name " + (String)object2);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                for (String string2 : arrayList) {
                    if (!this.foundClassNameMatch(string2, (String)object2)) continue;
                    Class clazz = this.processMatchingClass((String)object2, project);
                    this.logger.info("matching classname = " + (String)object2);
                    this.logger.info("Got clazz " + clazz);
                    if (clazz == null) continue;
                    arrayList2.add(object22);
                }
            }
        }
        List<String> list = hibernateEnvironment.getAnnotatedPOJOClassNames(fileObject);
        ArrayList<Class> arrayList3 = new ArrayList<Class>();
        if (list.size() != 0) {
            object = list.iterator();
            while (object.hasNext()) {
                iterator = (String)object.next();
                for (String string3 : arrayList) {
                    if (!this.foundClassNameMatch(string3, (String)((Object)iterator))) continue;
                    Class clazz = this.processMatchingClass((String)((Object)iterator), project);
                    this.logger.info("matching classname = " + iterator);
                    this.logger.info("Got clazz " + clazz);
                    if (clazz == null) continue;
                    arrayList3.add(clazz);
                }
            }
        }
        return this.getHibernateConfigurationForThisContext(fileObject, arrayList2, arrayList3);
    }

    private boolean foundClassNameMatch(String string, String string2) {
        boolean bl = false;
        if (string.indexOf(".") != -1) {
            if (string2.endsWith(string)) {
                bl = true;
            }
        } else if (string2.indexOf(".") == -1) {
            if (string2.equals(string)) {
                bl = true;
            }
        } else {
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            if (string3.equals(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private Class processMatchingClass(String string, Project project) {
        FileObject fileObject = HibernateUtil.findJavaFileObjectInProject(string, project);
        FileObject fileObject2 = HibernateUtil.getBuildFO(project);
        return this.checkAndCompile(string, fileObject, fileObject2, project);
    }

    private Class checkAndCompile(String string, FileObject fileObject, FileObject fileObject2, Project project) {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = classLoader.loadClass(string);
            if (clazz != null) {
                this.logger.info("Found pre-existing class. Returning.." + clazz.getName());
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.info("CNF. Processing .. " + string);
            try {
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
                string = string.replace(".", File.separator);
                File file = FileUtil.toFile((FileObject)fileObject);
                Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(file));
                ArrayList<File> arrayList = new ArrayList<File>();
                arrayList.add(FileUtil.toFile((FileObject)fileObject2));
                standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, arrayList);
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, this.getProjectClasspath(project, fileObject));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("-target");
                String string2 = System.getProperty("java.specification.version");
                if (string2 != null || !string2.equals("")) {
                    arrayList2.add(string2);
                } else {
                    arrayList2.add("1.5");
                }
                Boolean bl = javaCompiler.getTask(null, standardJavaFileManager, null, arrayList2, null, iterable).call();
                this.logger.info("b = " + bl);
                try {
                    string = string.replace(File.separator, ".");
                    clazz = classLoader.loadClass(string);
                    if (clazz != null) {
                        this.logger.info("Found class after processing. Returning.." + clazz.getName());
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.logger.info("CNF after processing.. " + string);
                    Exceptions.printStackTrace((Throwable)classNotFoundException2);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return clazz;
    }

    private List<File> getProjectClasspath(Project project, FileObject fileObject) {
        ArrayList<File> arrayList = new ArrayList<File>();
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        for (URL uRL : hibernateEnvironment.getProjectClassPath(fileObject)) {
            String string = uRL.getPath();
            string = string.replace("file:", "");
            string = string.replace("!/", "");
            File file = new File(string);
            arrayList.add(file);
        }
        this.logger.info("Adding classpath " + arrayList);
        return arrayList;
    }
}

