/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.service.spi;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataObject;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateEnvironmentImpl
implements HibernateEnvironment {
    private Project project;
    private Logger logger = Logger.getLogger(HibernateEnvironmentImpl.class.getName());

    public HibernateEnvironmentImpl(Project project) {
        this.project = project;
    }

    @Override
    public boolean canLoadDBDriver(HibernateConfiguration hibernateConfiguration) {
        String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
        if (string == null || "".equals(string)) {
            string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
        }
        if (string == null || "".equals(string)) {
            this.logger.info("dbDriver class could not be found from the config.");
            return false;
        }
        try {
            CustomClassLoader customClassLoader = new CustomClassLoader(this.getProjectClassPath(this.getAllHibernateConfigFileObjects().get(0)).toArray(new URL[0]), this.getClass().getClassLoader());
            customClassLoader.loadClass(string);
            this.logger.info("dbDriver loaded.");
            return true;
        }
        catch (Exception exception) {
            this.logger.info("Could not load dbDriver class. CNFE");
            return false;
        }
    }

    @Override
    public FileObject getLocation() {
        return Util.getSourceRoot(this.project);
    }

    @Override
    public List<String> getAllDatabaseTablesForProject() {
        return this.getAllDatabaseTables(HibernateUtil.getAllHibernateConfigurations(this.project).toArray(new HibernateConfiguration[0]));
    }

    @Override
    public List<String> getDatabaseTables(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<HibernateConfiguration> list = this.getHibernateConfigurationForMappingFile(fileObject);
            if (list.size() == 0) {
                return arrayList;
            }
            arrayList.addAll(HibernateUtil.getAllDatabaseTables(list.toArray(new HibernateConfiguration[0])));
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        catch (HibernateException hibernateException) {
            Exceptions.printStackTrace((Throwable)hibernateException);
        }
        return arrayList;
    }

    @Override
    public List<HibernateConfiguration> getAllHibernateConfigurationsFromProject() {
        return HibernateUtil.getAllHibernateConfigurations(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateConfigFileObjects() {
        return HibernateUtil.getAllHibernateConfigFileObjects(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateMappingFileObjects() {
        return HibernateUtil.getAllHibernateMappingFileObjects(this.project);
    }

    @Override
    public List<String> getAllHibernateMappings() {
        return HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateReverseEnggFileObjects() {
        return HibernateUtil.getAllHibernateReverseEnggFileObjects(this.project);
    }

    @Override
    public List<String> getAllDatabaseTables(HibernateConfiguration ... hibernateConfigurationArray) {
        try {
            return HibernateUtil.getAllDatabaseTables(hibernateConfigurationArray);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        catch (HibernateException hibernateException) {
            Exceptions.printStackTrace((Throwable)hibernateException);
        }
        return null;
    }

    @Override
    public List<TableColumn> getColumnsForTable(String string, FileObject fileObject) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        List<HibernateConfiguration> list = this.getHibernateConfigurationForMappingFile(fileObject);
        if (list.size() == 0) {
            return arrayList;
        }
        for (HibernateConfiguration hibernateConfiguration : list) {
            arrayList.addAll(HibernateUtil.getColumnsForTable(string, hibernateConfiguration));
        }
        return arrayList;
    }

    @Override
    public boolean addHibernateLibraryToProject(FileObject fileObject) {
        boolean bl = false;
        try {
            LibraryManager libraryManager = LibraryManager.getDefault();
            Library library = libraryManager.getLibrary("hibernate-support");
            Library library2 = libraryManager.getLibrary("ejb3-persistence");
            ProjectClassPathModifier projectClassPathModifier = (ProjectClassPathModifier)this.project.getLookup().lookup(ProjectClassPathModifier.class);
            this.project.getProjectDirectory().getFileSystem().refresh(true);
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.getAllHibernateConfigFileObjects().get(0), (String)"classpath/execute");
            bl = !this.containsClass(classPath, "javax.persistence.EntityManager") ? ProjectClassPathModifier.addLibraries((Library[])new Library[]{library, library2}, (FileObject)fileObject, (String)"classpath/compile") : ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)"classpath/compile");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            bl = false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Exceptions.printStackTrace((Throwable)unsupportedOperationException);
        }
        return bl;
    }

    @Override
    public List<String> getAllHibernateMappingsFromConfiguration(HibernateConfiguration hibernateConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        for (boolean bl : sessionFactory.getMapping()) {
            String string2 = sessionFactory.getAttributeValue("Mapping", n, "resource");
            if (string2 != null) {
                arrayList.add(string2);
            }
            if ((string2 = sessionFactory.getAttributeValue("Mapping", n, "file")) != null) {
                arrayList.add(string2);
            }
            if ((string2 = sessionFactory.getAttributeValue("Mapping", n, "package")) != null) {
                arrayList2.add(string2);
            }
            ++n;
        }
        if (arrayList2.size() != 0) {
            Object object = HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (String string2 : arrayList2) {
                    if (!string.startsWith(string2 = string2.replace(".", "/"))) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    private List<HibernateConfiguration> getHibernateConfigurationForMappingFile(FileObject fileObject) {
        ArrayList<HibernateConfiguration> arrayList = new ArrayList<HibernateConfiguration>();
        for (HibernateConfiguration hibernateConfiguration : this.getAllHibernateConfigurationsFromProject()) {
            for (String string : this.getAllHibernateMappingsFromConfiguration(hibernateConfiguration)) {
                if (string.trim().equals("") || !fileObject.getPath().contains(string)) continue;
                arrayList.add(hibernateConfiguration);
            }
        }
        return arrayList;
    }

    @Override
    public List<URL> getProjectClassPath(FileObject fileObject) {
        return HibernateUtil.getProjectClassPathEntries(fileObject);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public List<String> getAnnotatedPOJOClassNames(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)fileObject);
            HibernateConfiguration hibernateConfiguration = hibernateCfgDataObject.getHibernateConfiguration();
            SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
            int n = 0;
            for (boolean bl : sessionFactory.getMapping()) {
                String string;
                if ((string = sessionFactory.getAttributeValue("Mapping", n++, "class")) == null) continue;
                arrayList.add(string);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.logger.log(Level.INFO, "DataObject not found during Annototated POJO procesing.", dataObjectNotFoundException);
        }
        return arrayList;
    }

    @Override
    public Map<FileObject, List<String>> getAllPOJONamesFromConfiguration(FileObject fileObject) {
        HashMap<FileObject, List<String>> hashMap = new HashMap<FileObject, List<String>>();
        try {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)fileObject);
            for (String string : this.getAllHibernateMappingsFromConfiguration(hibernateCfgDataObject.getHibernateConfiguration())) {
                for (FileObject fileObject2 : this.getAllHibernateMappingFileObjects()) {
                    if (!string.contains(fileObject2.getName())) continue;
                    List<String> list = this.getPOJONameFromMapping(fileObject2);
                    hashMap.put(fileObject2, list);
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return hashMap;
    }

    private List<String> getPOJONameFromMapping(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HibernateMappingDataObject hibernateMappingDataObject = (HibernateMappingDataObject)DataObject.find((FileObject)fileObject);
            for (MyClass myClass : hibernateMappingDataObject.getHibernateMapping().getMyClass()) {
                String string = myClass.getAttributeValue("name");
                arrayList.add(string);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return arrayList;
    }

    private boolean containsClass(ClassPath classPath, String string) {
        String string2 = string.replace('.', '/') + ".class";
        return classPath.findResource(string2) != null;
    }
}

