/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaManager;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaTableProvider;
import org.netbeans.modules.hibernate.wizards.support.EmptyTableProvider;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableClosure;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;
import org.netbeans.modules.hibernate.wizards.support.TableUISupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateRevengDatabaseTablesPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DBSchemaManager dbschemaManager = new DBSchemaManager();
    private DatabaseConnection dbconn;
    private String schemaName;
    private String catalogName;
    private boolean sourceSchemaUpdateEnabled;
    private Project project;
    private HibernateEnvironment env;
    List<FileObject> configFileObjects;
    List<String> databaseTables;
    private TableClosure tableClosure;
    private SchemaElement sourceSchemaElement;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableTablesLabel;
    private JList availableTablesList;
    private JScrollPane availableTablesScrollPane;
    private JPanel buttonPanel;
    private JComboBox cmbDatabaseConn;
    private JLabel jLabel1;
    private JScrollPane jScrollPane3;
    private JButton removeAllButton;
    private JButton removeButton;
    private ButtonGroup schemaSource;
    private JLabel selectedTablesLabel;
    private JList selectedTablesList;
    private JScrollPane selectedTablesScrollPane;
    private JCheckBox tableClosureCheckBox;
    private JTextPane tableError;
    private JPanel tablesPanel;

    public HibernateRevengDatabaseTablesPanel(Project project) {
        this.initComponents();
        this.project = project;
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                HibernateRevengDatabaseTablesPanel.this.updateButtons();
            }
        };
        this.availableTablesList.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void initialize(Project project) {
        this.project = project;
        this.fillConfiguration();
        this.sourceSchemaUpdateEnabled = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HibernateRevengDatabaseTablesPanel.this.fillDatabaseTables();
            }
        });
    }

    private void fillConfiguration() {
        this.env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        String[] stringArray = this.getConfigFilesFromProject(this.project);
        this.cmbDatabaseConn.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fileObject : this.configFileObjects) {
            arrayList.add(fileObject.getNameExt());
        }
        return arrayList.toArray(new String[0]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    private void fillDatabaseTables() {
        if (!this.sourceSchemaUpdateEnabled) {
            return;
        }
        TableProvider tableProvider = null;
        this.sourceSchemaElement = null;
        this.dbconn = null;
        Object object = this.cmbDatabaseConn.getSelectedItem();
        HibernateConfiguration hibernateConfiguration = null;
        try {
            if (this.cmbDatabaseConn.getSelectedIndex() != -1) {
                hibernateConfiguration = ((HibernateCfgDataObject)DataObject.find((FileObject)this.configFileObjects.get(this.cmbDatabaseConn.getSelectedIndex()))).getHibernateConfiguration();
                this.dbconn = HibernateUtil.getDBConnection(hibernateConfiguration);
                if (this.dbconn != null) {
                    this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                    this.schemaName = this.dbconn.getSchema();
                    Connection connection = this.dbconn.getJDBCConnection();
                    if (connection != null) {
                        this.catalogName = connection.getCatalog();
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
        catch (SQLException sQLException) {
            HibernateRevengDatabaseTablesPanel.notify(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
        }
        tableProvider = this.sourceSchemaElement != null ? new DBSchemaTableProvider(this.sourceSchemaElement) : new EmptyTableProvider();
        this.tableClosure = new TableClosure(tableProvider);
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
        TableUISupport.connectAvailable(this.availableTablesList, this.tableClosure);
        TableUISupport.connectSelected(this.selectedTablesList, this.tableClosure);
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void updateButtons() {
        Set<Table> set = TableUISupport.getSelectedTables(this.availableTablesList);
        this.addButton.setEnabled(this.tableClosure.canAddAllTables(set));
        this.addAllButton.setEnabled(this.tableClosure.canAddSomeTables(this.tableClosure.getAvailableTables()));
        Set<Table> set2 = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.removeButton.setEnabled(this.tableClosure.canRemoveAllTables(set2));
        this.removeAllButton.setEnabled(this.tableClosure.getSelectedTables().size() > 0);
        this.tableError.setText("");
        for (Table table : set) {
            if (!table.isDisabled()) continue;
            if (table.getDisabledReason() instanceof Table.ExistingDisabledReason) {
                String string = ((Table.ExistingDisabledReason)table.getDisabledReason()).getFQClassName();
                this.tableError.setText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"MSG_Already_Mapped", (Object[])new Object[]{table.getName(), string}));
                break;
            }
            if (!(table.getDisabledReason() instanceof Table.NoPrimaryKeyDisabledReason)) continue;
            this.tableError.setText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"MSG_No_Primary_Key", (Object[])new Object[]{table.getName()}));
            break;
        }
    }

    public FileObject getConfigurationFile() {
        if (this.cmbDatabaseConn.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbDatabaseConn.getSelectedIndex());
        }
        return null;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    private static void notify(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private void initComponents() {
        this.schemaSource = new ButtonGroup();
        this.cmbDatabaseConn = new JComboBox();
        this.tablesPanel = new TablesPanel();
        this.availableTablesLabel = new JLabel();
        this.availableTablesScrollPane = new JScrollPane();
        this.availableTablesList = TableUISupport.createTableList();
        this.selectedTablesLabel = new JLabel();
        this.selectedTablesScrollPane = new JScrollPane();
        this.selectedTablesList = TableUISupport.createTableList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.tableClosureCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.tableError = new JTextPane();
        this.jLabel1 = new JLabel();
        this.setName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"LBL_DatabaseTables"));
        this.cmbDatabaseConn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengDatabaseTablesPanel.this.cmbDatabaseConnActionPerformed(actionEvent);
            }
        });
        this.tablesPanel.setLayout(new GridBagLayout());
        this.availableTablesLabel.setLabelFor(this.availableTablesList);
        Mnemonics.setLocalizedText((JLabel)this.availableTablesLabel, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_AvailableTables"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.availableTablesLabel, gridBagConstraints);
        this.availableTablesLabel.getAccessibleContext().setAccessibleName("");
        this.availableTablesList.setNextFocusableComponent(this.addButton);
        this.availableTablesScrollPane.setViewportView(this.availableTablesList);
        this.availableTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSN_AvailableTables"));
        this.availableTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSD_AvailableTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.availableTablesScrollPane, gridBagConstraints);
        this.selectedTablesLabel.setLabelFor(this.selectedTablesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedTablesLabel, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.selectedTablesLabel, gridBagConstraints);
        this.selectedTablesLabel.getAccessibleContext().setAccessibleName("");
        this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
        this.selectedTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSN_SelectedTables"));
        this.selectedTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSD_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.selectedTablesScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengDatabaseTablesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengDatabaseTablesPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_AddAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengDatabaseTablesPanel.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_RemoveAll"));
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengDatabaseTablesPanel.this.removeAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.tablesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.tableClosureCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tableClosureCheckBox, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_IncludeRelatedTables"));
        this.tableClosureCheckBox.setToolTipText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_IncludeRelatedTables"));
        this.tableClosureCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableClosureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.tableClosureCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.tablesPanel.add((Component)this.tableClosureCheckBox, gridBagConstraints);
        this.tableClosureCheckBox.getAccessibleContext().setAccessibleName("");
        this.jScrollPane3.setBorder(null);
        this.tableError.setEditable(false);
        this.tableError.setOpaque(false);
        this.jScrollPane3.setViewportView(this.tableError);
        this.jLabel1.setLabelFor(this.cmbDatabaseConn);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Configuration"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cmbDatabaseConn, 0, 409, Short.MAX_VALUE)).add(2, (Component)this.tablesPanel, -1, 501, Short.MAX_VALUE).add(2, (Component)this.jScrollPane3, -1, 501, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cmbDatabaseConn, -2, -1, -2)).addPreferredGap(0, 23, Short.MAX_VALUE).add((Component)this.tablesPanel, -2, 235, -2).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 38, -2)));
    }

    private void tableClosureCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        this.tableClosure.removeAllTables();
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        this.tableClosure.addAllTables();
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Set<Table> set = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.tableClosure.removeTables(set);
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Set<Table> set = TableUISupport.getSelectedTables(this.availableTablesList);
        this.tableClosure.addTables(set);
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void cmbDatabaseConnActionPerformed(ActionEvent actionEvent) {
        this.fillDatabaseTables();
    }

    private final class TablesPanel
    extends JPanel {
        private TablesPanel() {
        }

        public void doLayout() {
            super.doLayout();
            Rectangle rectangle = HibernateRevengDatabaseTablesPanel.this.availableTablesScrollPane.getBounds();
            Rectangle rectangle2 = HibernateRevengDatabaseTablesPanel.this.selectedTablesScrollPane.getBounds();
            if (Math.abs(rectangle.width - rectangle2.width) > 1) {
                GridBagConstraints gridBagConstraints = ((GridBagLayout)this.getLayout()).getConstraints(HibernateRevengDatabaseTablesPanel.this.buttonPanel);
                int n = this.getWidth() - HibernateRevengDatabaseTablesPanel.this.buttonPanel.getWidth() - gridBagConstraints.insets.left - gridBagConstraints.insets.right;
                int n2 = n / 2;
                int n3 = n2 - rectangle.width;
                rectangle.width = n2;
                HibernateRevengDatabaseTablesPanel.this.availableTablesScrollPane.setBounds(rectangle);
                Rectangle rectangle3 = HibernateRevengDatabaseTablesPanel.this.buttonPanel.getBounds();
                rectangle3.x += n3;
                HibernateRevengDatabaseTablesPanel.this.buttonPanel.setBounds(rectangle3);
                Rectangle rectangle4 = HibernateRevengDatabaseTablesPanel.this.selectedTablesLabel.getBounds();
                rectangle4.x += n3;
                HibernateRevengDatabaseTablesPanel.this.selectedTablesLabel.setBounds(rectangle4);
                rectangle2.x += n3;
                rectangle2.width = n - n2;
                HibernateRevengDatabaseTablesPanel.this.selectedTablesScrollPane.setBounds(rectangle2);
                Rectangle rectangle5 = HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBox.getBounds();
                rectangle5.x += n3;
                rectangle5.width = n - n2;
                HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBox.setBounds(rectangle5);
            }
        }
    }
}

