/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.util.XMLHelper;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataObject;
import org.netbeans.modules.hibernate.reveng.model.HibernateReverseEngineering;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateRevengCodeGenWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDbTablesWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateRevengWizardHelper;
import org.netbeans.modules.hibernate.wizards.Util;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRevengWizard
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final String PROP_HELPER = "wizard-helper";
    private int index;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private HibernateRevengWizardHelper helper;
    private HibernateRevengDbTablesWizardDescriptor dbTablesDescriptor;
    private HibernateRevengCodeGenWizardDescriptor codeGenDescriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private final String DEFAULT_REVENG_FILENAME = "hibernate.reveng";
    private final String CATALOG_NAME = "match-catalog";
    private final String EXCLUDE_NAME = "exclude";
    private final String ATTRIBUTE_NAME = "match-schema";
    private final String MATCH_NAME = "match-name";
    private final String resourceAttr = "resource";
    private final String classAttr = "class";
    private XMLHelper xmlHelper;
    private EntityResolver entityResolver;
    private Logger logger = Logger.getLogger(HibernateRevengWizard.class.getName());

    public static HibernateRevengWizard create() {
        return new HibernateRevengWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Object object;
            String[] stringArray;
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                stringArray = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)stringArray).getSourceGroups("generic");
                object = Templates.createSimpleTargetChooser((Project)stringArray, (SourceGroup[])sourceGroupArray);
                this.panels = new WizardDescriptor.Panel[]{object, this.dbTablesDescriptor, this.codeGenDescriptor};
            }
            stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                object = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = ((Component)object).getName();
                }
                if (!(object instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)object;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    static HibernateRevengWizardHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (HibernateRevengWizardHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    public String name() {
        return NbBundle.getMessage(HibernateRevengWizard.class, (String)"LBL_RevEngWizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    private boolean foundRevengFileInProject(List<FileObject> list, String string) {
        for (FileObject fileObject : list) {
            if (!fileObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Set instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public final void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        Object object2;
        this.wizardDescriptor = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.helper = new HibernateRevengWizardHelper(this.project);
        wizardDescriptor.putProperty(PROP_HELPER, (Object)this.helper);
        this.dbTablesDescriptor = new HibernateRevengDbTablesWizardDescriptor(this.project);
        this.codeGenDescriptor = new HibernateRevengCodeGenWizardDescriptor(this.project, this.wizardDescriptor);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            object2 = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            Object object3 = object = object2 != null ? object2.getLocation() : null;
            if (object != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)object);
            }
        }
        if (wizardDescriptor instanceof TemplateWizard) {
            object2 = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (object2 == null) {
                return;
            }
            object = object2.getAllHibernateReverseEnggFileObjects();
            String string = "hibernate.reveng";
            if (!object.isEmpty() && this.foundRevengFileInProject((List<FileObject>)object, "hibernate.reveng")) {
                int n = object.size();
                string = "hibernate" + n++ + ".reveng";
                while (this.foundRevengFileInProject((List<FileObject>)object, string)) {
                    string = "hibernate" + n++ + ".reveng";
                }
            }
            ((TemplateWizard)wizardDescriptor).setTargetName(string);
        }
        object2 = "Templates/Hibernate/HibernateReveng";
        wizardDescriptor.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(HibernateRevengWizard.class, (String)object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClasses(FileObject fileObject, ProgressHandle progressHandle) throws IOException {
        JDBCMetaDataConfiguration jDBCMetaDataConfiguration = null;
        ReverseEngineeringSettings reverseEngineeringSettings = null;
        ClassLoader classLoader = null;
        File file = FileUtil.toFile((FileObject)this.helper.getConfigurationFile());
        File file2 = FileUtil.toFile((FileObject)this.helper.getLocation().getRootFolder());
        try {
            OverrideRepository overrideRepository;
            this.logger.info("Setting up classloader");
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            CustomClassLoader customClassLoader = new CustomClassLoader(hibernateEnvironment.getProjectClassPath(fileObject).toArray(new URL[0]), this.getClass().getClassLoader());
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(customClassLoader);
            try {
                jDBCMetaDataConfiguration = new JDBCMetaDataConfiguration();
                overrideRepository = new OverrideRepository();
                Configuration configuration = jDBCMetaDataConfiguration.configure(file);
                overrideRepository.addFile(FileUtil.toFile((FileObject)fileObject));
                DefaultReverseEngineeringStrategy defaultReverseEngineeringStrategy = new DefaultReverseEngineeringStrategy();
                reverseEngineeringSettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)defaultReverseEngineeringStrategy);
                reverseEngineeringSettings.setDefaultPackageName(this.helper.getPackageName());
                defaultReverseEngineeringStrategy.setSettings(reverseEngineeringSettings);
                jDBCMetaDataConfiguration.setReverseEngineeringStrategy(overrideRepository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)defaultReverseEngineeringStrategy));
                jDBCMetaDataConfiguration.readFromJDBC();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            try {
                if (this.helper.getDomainGen()) {
                    progressHandle.progress(NbBundle.getMessage(HibernateRevengWizard.class, (String)"HibernateRevengCodeGenerationPanel_WizardProgress_GenPOJO"), 2);
                    overrideRepository = new POJOExporter((Configuration)jDBCMetaDataConfiguration, file2);
                    overrideRepository.getProperties().setProperty("jdk", new Boolean(this.helper.getJavaSyntax()).toString());
                    overrideRepository.getProperties().setProperty("ejb3", new Boolean(this.helper.getEjbAnnotation()).toString());
                    overrideRepository.start();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            try {
                if (this.helper.getHbmGen()) {
                    progressHandle.progress(NbBundle.getMessage(HibernateRevengWizard.class, (String)"HibernateRevengCodeGenerationPanel_WizardProgress_GenMapping"), 3);
                    overrideRepository = new HibernateMappingExporter((Configuration)jDBCMetaDataConfiguration, file2);
                    overrideRepository.start();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    public void updateConfiguration() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.helper.getConfigurationFile());
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)dataObject;
            SessionFactory sessionFactory = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory();
            FileObject fileObject = SourceGroups.getFolderForPackage((SourceGroup)this.helper.getLocation(), (String)this.helper.getPackageName(), (boolean)false);
            if (fileObject != null && fileObject.isFolder()) {
                fileObject.getFileSystem().refresh(true);
                Enumeration enumeration = fileObject.getChildren(true);
                if (this.helper.getDomainGen() && this.helper.getEjbAnnotation() && !this.helper.getHbmGen()) {
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-java")) continue;
                        int n = sessionFactory.addMapping(true);
                        String string = HibernateUtil.getRelativeSourcePath(fileObject2, Util.getSourceRoot(this.project));
                        String string2 = string.replaceAll("/", ".").substring(0, string.indexOf(".java", 0));
                        sessionFactory.setAttributeValue("Mapping", n, "class", string2);
                        hibernateCfgDataObject.modelUpdatedFromUI();
                        hibernateCfgDataObject.save();
                    }
                } else {
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject3 = (FileObject)enumeration.nextElement();
                        if (fileObject3.getNameExt() == null || !fileObject3.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
                        int n = sessionFactory.addMapping(true);
                        sessionFactory.setAttributeValue("Mapping", n, "resource", HibernateUtil.getRelativeSourcePath(fileObject3, Util.getSourceRoot(this.project)));
                        hibernateCfgDataObject.modelUpdatedFromUI();
                        hibernateCfgDataObject.save();
                    }
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        progressHandle.start(4);
        progressHandle.progress(NbBundle.getMessage(HibernateRevengWizard.class, (String)"HibernateRevengCodeGenerationPanel_WizardProgress_CreatingReveng"), 1);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        String string = Templates.getTargetName((WizardDescriptor)this.wizardDescriptor);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wizardDescriptor);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string);
        try {
            HibernateRevengDataObject hibernateRevengDataObject = (HibernateRevengDataObject)dataObject2;
            HibernateReverseEngineering hibernateReverseEngineering = hibernateRevengDataObject.getHibernateReverseEngineering();
            ArrayList arrayList = (ArrayList)this.helper.getSelectedTables().getTables();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = hibernateReverseEngineering.addTableFilter(true);
                if (this.helper.getCatalogName() != null && !"".equals(this.helper.getCatalogName())) {
                    hibernateReverseEngineering.setAttributeValue("TableFilter", n, "match-catalog", this.helper.getCatalogName());
                } else {
                    hibernateReverseEngineering.setAttributeValue("TableFilter", n, "match-catalog", null);
                }
                if (this.helper.getSchemaName() != null && !"".equals(this.helper.getSchemaName())) {
                    hibernateReverseEngineering.setAttributeValue("TableFilter", n, "match-schema", this.helper.getSchemaName());
                } else {
                    hibernateReverseEngineering.setAttributeValue("TableFilter", n, "match-schema", null);
                }
                hibernateReverseEngineering.setAttributeValue("TableFilter", n, "match-name", ((Table)arrayList.get(i)).getName());
                hibernateReverseEngineering.setAttributeValue("TableFilter", n, "exclude", null);
            }
            hibernateRevengDataObject.addReveng();
            hibernateRevengDataObject.save();
            if (arrayList.size() > 0) {
                this.generateClasses(hibernateRevengDataObject.getPrimaryFile(), progressHandle);
                progressHandle.progress(NbBundle.getMessage(HibernateRevengWizard.class, (String)"HibernateRevengCodeGenerationPanel_WizardProgress_UpdateConf"), 4);
                this.updateConfiguration();
            }
            return Collections.singleton(hibernateRevengDataObject.getPrimaryFile());
        }
        catch (Exception exception) {
            return Collections.EMPTY_SET;
        }
    }
}

