/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class WelcomeOptions {
    private static WelcomeOptions theInstance;
    private static final String PROP_SHOW_ON_STARTUP = "showOnStartup";
    private static final String PROP_LAST_ACTIVE_TAB = "lastActiveTab";
    private static final String PROP_START_COUNTER = "startCounter";
    private PropertyChangeSupport propSupport;

    private WelcomeOptions() {
    }

    private Preferences prefs() {
        return NbPreferences.forModule(WelcomeOptions.class);
    }

    public static synchronized WelcomeOptions getDefault() {
        if (null == theInstance) {
            theInstance = new WelcomeOptions();
        }
        return theInstance;
    }

    public void setShowOnStartup(boolean bl) {
        boolean bl2 = this.isShowOnStartup();
        this.prefs().putBoolean(PROP_SHOW_ON_STARTUP, bl);
        if (null != this.propSupport) {
            this.propSupport.firePropertyChange(PROP_SHOW_ON_STARTUP, bl2, bl);
        }
    }

    public boolean isShowOnStartup() {
        return this.prefs().getBoolean(PROP_SHOW_ON_STARTUP, true);
    }

    public void setLastActiveTab(int n) {
        int n2 = this.getLastActiveTab();
        this.prefs().putInt(PROP_LAST_ACTIVE_TAB, n);
        if (null != this.propSupport) {
            this.propSupport.firePropertyChange(PROP_LAST_ACTIVE_TAB, n2, n);
        }
    }

    public int getLastActiveTab() {
        return this.prefs().getInt(PROP_LAST_ACTIVE_TAB, -1);
    }

    public boolean isSecondStart() {
        return this.prefs().getInt(PROP_START_COUNTER, -1) == 2;
    }

    public void incrementStartCounter() {
        int n = this.prefs().getInt(PROP_START_COUNTER, 0) + 1;
        if (n > 3) {
            return;
        }
        this.prefs().putInt(PROP_START_COUNTER, n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propSupport) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propSupport) {
            return;
        }
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

