/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EarActionProvider
implements ActionProvider {
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "run", "debug", "redeploy", "verify", "delete", "copy", "move", "rename"};
    private static final Set<String> actionsDisabledForCoS = new HashSet<String>(3);
    EarProject project;
    private final UpdateHelper updateHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public EarActionProvider(EarProject earProject, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.updateHelper = updateHelper;
        this.project = earProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Properties properties = new Properties();
                String[] stringArray = EarActionProvider.this.getTargetNames(string, lookup, properties);
                if (stringArray == null) {
                    return;
                }
                if (stringArray.length == 0) {
                    stringArray = null;
                }
                if (properties.keySet().size() == 0) {
                    properties = null;
                }
                try {
                    ActionUtils.runTarget((FileObject)EarActionProvider.this.findBuildXml(), (String[])stringArray, (Properties)properties);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
        runnable.run();
    }

    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String[] stringArray = this.commands.get(string);
        if (string.equals("run") || string.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                String string2 = NbBundle.getMessage(EarActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 2));
                return null;
            }
            if (string.equals("run") && this.isDebugged()) {
                properties.setProperty("is.debugged", "true");
            }
            if (string.equals("redeploy")) {
                properties.setProperty("forceRedeploy", "true");
            } else {
                properties.setProperty("forceRedeploy", "false");
            }
        } else if (string.equals("debug")) {
            NotifyDescriptor.Message message;
            if (!this.isSelectedServer()) {
                String string3 = NbBundle.getMessage(EarActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
                return null;
            }
            if (this.project.evaluator().getProperty("app.client") != null) {
                message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarActionProvider.class, (String)"MSG_Server_State_Question"), 3);
                message.setOptionType(0);
                message.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == NotifyDescriptor.YES_OPTION) {
                    message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarActionProvider.class, (String)"MSG_Server_State"), 1);
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return null;
                }
            }
            if (this.isDebugged()) {
                properties.setProperty("is.debugged", "true");
            }
            if (null != (message = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class))) {
                StringBuilder stringBuilder = new StringBuilder();
                Set set = message.getSubprojects();
                for (Project project : set) {
                    FileObject fileObject;
                    WebModule webModule;
                    WebModuleProvider webModuleProvider = (WebModuleProvider)project.getLookup().lookup(WebModuleProvider.class);
                    if (null == webModuleProvider || null == (webModule = webModuleProvider.findWebModule(project.getProjectDirectory())) || null == (fileObject = webModule.getDocumentBase())) continue;
                    stringBuilder.append(FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + ":");
                }
                properties.setProperty("ear.docbase.dirs", stringBuilder.toString());
            }
        } else if (stringArray == null) {
            throw new IllegalArgumentException(string);
        }
        return stringArray;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        boolean bl;
        if (this.findBuildXml() == null) {
            return false;
        }
        boolean bl2 = bl = !Boolean.parseBoolean(this.project.getAntProjectHelper().getProperties("nbproject/project.properties").getProperty("disable.deploy.on.save"));
        if (bl && actionsDisabledForCoS.contains(string)) {
            return false;
        }
        if (string.equals(COMMAND_VERIFY)) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            return j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport();
        }
        if (string.equals("run")) {
            boolean bl3 = this.project.evaluator().getProperty("app.client") != null;
            return this.isSelectedServer() && (!bl3 || !this.isTargetServerRemote());
        }
        return true;
    }

    private boolean isDebugged() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (null == j2eeModuleProvider) {
            return false;
        }
        ServerDebugInfo serverDebugInfo = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            Object object;
            Session session = sessionArray[i];
            if (session == null || (object = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            if (null == serverDebugInfo && null == (serverDebugInfo = j2eeModuleProvider.getServerDebugInfo())) {
                return false;
            }
            AttachingDICookie attachingDICookie = (AttachingDICookie)object;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? attachingDICookie.getSharedMemoryName().equalsIgnoreCase(serverDebugInfo.getShmemName()) : attachingDICookie.getHostName() != null && attachingDICookie.getHostName().equalsIgnoreCase(serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedServer() {
        String[] stringArray;
        String string;
        String string2 = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string2 != null && (string = Deployment.getDefault().getServerID(string2)) != null) {
            return true;
        }
        string = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (string != null && (stringArray = Deployment.getDefault().getInstancesOfServer(string)).length > 0) {
            EarProjectProperties.setServerInstance(this.project, this.updateHelper, stringArray[0]);
            return true;
        }
        return false;
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
        String string = instanceProperties.getProperty("DOMAIN");
        String string2 = instanceProperties.getProperty("LOCATION");
        return "".equals(string) && "".equals(string2);
    }

    static {
        Collections.addAll(actionsDisabledForCoS, "build", "compile.single");
    }
}

