/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.netbeans.modules.compapp.projects.jbi.anttasks.ConnectionResolver;
import org.netbeans.modules.compapp.projects.jbi.anttasks.ServiceUnitDescriptorEnhancer;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Connection;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BCSUDescriptorBuilder
implements Serializable {
    public static final String VERSION_ATTR_NAME = "version";
    public static final String VERSION_ATTR_VALUE = "1.0";
    public static final String NS_ATTR_NAME = "xmlns";
    public static final String NS_XSI_ATTR_NAME = "xmlns:xsi";
    public static final String NS_XSI_ATTR_VALUE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_ATTR_NAME = "xsi:schemaLocation";
    public static final String XSI_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi jbi.xsd";
    public static final String NAMESPACE_PREFIX = "ns";
    private Document document;

    public void buildDOMTree(ConnectionResolver connectionResolver, String bcName) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        Element root = this.document.createElement("jbi");
        root.setAttribute(VERSION_ATTR_NAME, VERSION_ATTR_VALUE);
        root.setAttribute(NS_ATTR_NAME, "http://java.sun.com/xml/ns/jbi");
        Map<String, String> nsMap = connectionResolver.getNamespaceMap();
        for (String key : nsMap.keySet()) {
            String value = nsMap.get(key);
            root.setAttribute("xmlns:" + key, value);
        }
        this.document.appendChild(root);
        Element services = this.document.createElement("services");
        services.setAttribute("binding-component", "true");
        root.appendChild(services);
        List<Connection>[] list = connectionResolver.getBCConnections().get(bcName);
        List<Connection> clist = list[0];
        List<Connection> plist = list[1];
        HashSet<Endpoint> providerSet = new HashSet<Endpoint>();
        for (Connection con : plist) {
            Endpoint provide = con.getProvide();
            if (providerSet.contains(provide)) continue;
            providerSet.add(provide);
            Element providesElement = this.document.createElement("provides");
            this.setEndpointElementAttributes(providesElement, provide, root, nsMap);
            services.appendChild(providesElement);
        }
        for (Connection con : clist) {
            Endpoint consume = con.getConsume();
            Element consumesElement = this.document.createElement("consumes");
            this.setEndpointElementAttributes(consumesElement, consume, root, nsMap);
            services.appendChild(consumesElement);
        }
        this.document.normalizeDocument();
    }

    public void decorateEndpoints(Document casaDocument) {
        ServiceUnitDescriptorEnhancer.decorateEndpoints(this.document, casaDocument);
    }

    private void setEndpointElementAttributes(Element endpointElement, Endpoint endpoint, Element root, Map<String, String> nsMap) {
        endpointElement.setAttribute("interface-name", this.xlateQName(endpoint.getInterfaceQName(), root, nsMap));
        endpointElement.setAttribute("service-name", this.xlateQName(endpoint.getServiceQName(), root, nsMap));
        endpointElement.setAttribute("endpoint-name", endpoint.getEndpointName());
    }

    private String xlateQName(QName qname, Element root, Map<String, String> map) {
        String ns = qname.getNamespaceURI();
        if (ns == null || ns.trim().length() == 0) {
            return qname.getLocalPart();
        }
        String name = qname.getLocalPart();
        String prefix = this.findNamespacePrefix(map, ns, root);
        return prefix + ":" + name;
    }

    private String findNamespacePrefix(Map<String, String> map, String uri, Element root) {
        for (String prefix : map.keySet()) {
            if (!map.get(prefix).equals(uri)) continue;
            return prefix;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String prefix;
            prefix = NAMESPACE_PREFIX + i;
            if (map.get(prefix) != null) continue;
            map.put(prefix, uri);
            root.setAttribute("xmlns:" + prefix, uri);
            return prefix;
        }
        return null;
    }

    public void writeToFile(String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + "jbi.xml";
        XmlUtil.writeToFile((String)fileLocation, (Document)this.document);
    }

    public byte[] writeToBytes() throws TransformerConfigurationException, TransformerException, Exception {
        return XmlUtil.writeToBytes((Document)this.document);
    }
}

