/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import com.sun.esb.management.api.configuration.ConfigurationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.compapp.projects.jbi.anttasks.AbstractDebugEnvironmentTask;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUpDebugEnvironment
extends AbstractDebugEnvironmentTask {
    public void execute() throws BuildException {
        this.log("SetUpDebugEnvironment:", 4);
        Map<String, Boolean> debugEnabledMap = this.initDebugEnabledMap();
        Set<String> seNames = this.getUsedServiceEngineNames();
        ConfigurationService adminService = this.getConfigurationService();
        HashMap<String, Object> debugParams = new HashMap<String, Object>();
        for (String seName : seNames) {
            try {
                String debugPort;
                Properties configProperties = adminService.getComponentConfiguration(seName, "server");
                String debugFlag = configProperties.getProperty("DebugEnabled");
                if (debugFlag == null) continue;
                Boolean debugEnabled = Boolean.parseBoolean(debugFlag);
                this.log("The original debug-enabled property for " + seName + " is " + debugEnabled, 4);
                debugEnabledMap.put(seName, debugEnabled);
                if (!debugEnabled.booleanValue()) {
                    Properties properties = new Properties();
                    properties.setProperty("DebugEnabled", "true");
                    adminService.setComponentConfiguration(seName, properties, "server");
                }
                if ((debugPort = configProperties.getProperty("DebugPort")) == null) continue;
                HashMap<String, String> seParams = new HashMap<String, String>();
                seParams.put("port", debugPort);
                debugParams.put(seName, seParams);
            }
            catch (Exception e) {
                this.log(e.getMessage(), 1);
            }
        }
        if (!debugParams.isEmpty()) {
            try {
                String projectBaseDir = this.getProject().getProperty("basedir");
                debugParams.put("projectBaseDir", projectBaseDir);
                String serverInstance = this.getProject().getProperty("j2ee.server.instance");
                debugParams.put("j2eeServerInstance", serverInstance);
                DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"CompAppDebuggerInfo", (Object[])new Object[]{debugParams}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Set<String> getUsedServiceEngineNames() {
        HashSet<String> ret = new HashSet<String>();
        try {
            Project p = this.getProject();
            String propsFilePath = p.getProperty("basedir") + File.separator + "nbproject" + File.separator + "project.properties";
            Properties props = new Properties();
            props.load(new FileInputStream(new File(propsFilePath)));
            String components = props.getProperty("jbi.content.component");
            String[] seNames = components.split("\\s*;\\s*");
            ret.addAll(Arrays.asList(seNames));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret;
    }
}

