/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.common.DatasourceCustomizer;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatasourceUIHelper {
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(DatasourceUIHelper.class, (String)"LBL_NEW_DATASOURCE");
        }
    };

    public static ListCellRenderer createDatasourceListCellRenderer() {
        return new DatasourceListCellRenderer();
    }

    public static Comparator<Datasource> createDatasourceComparator() {
        return new DatasourceComparator();
    }

    private DatasourceUIHelper() {
    }

    public static void connect(J2eeModuleProvider j2eeModuleProvider, JComboBox jComboBox) {
        DatasourceUIHelper.connect(j2eeModuleProvider, jComboBox, null);
    }

    private static final void connect(final J2eeModuleProvider j2eeModuleProvider, final JComboBox jComboBox, Datasource datasource) {
        assert (j2eeModuleProvider != null);
        jComboBox.setEditor(new DatasourceComboBoxEditor(jComboBox.getEditor()));
        jComboBox.setRenderer(new DatasourceListCellRenderer());
        ArrayList<2> arrayList = new ArrayList<2>();
        final ArrayList<Datasource> arrayList2 = new ArrayList<Datasource>();
        arrayList.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                context.progress(string);
                try {
                    arrayList2.addAll(DatasourceUIHelper.getDatasources(j2eeModuleProvider));
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        ProgressSupport.invoke(arrayList);
        DatasourceUIHelper.populate(arrayList2, j2eeModuleProvider.isDatasourceCreationSupported(), jComboBox, datasource, false);
        JComboBox jComboBox2 = jComboBox.isEditable() ? jComboBox.getEditor().getEditorComponent() : jComboBox;
        jComboBox2.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                int n = keyEvent.getKeyCode();
                if (10 == n && (object = jComboBox.getSelectedItem()) == NEW_ITEM) {
                    DatasourceUIHelper.performCreateDatasource(j2eeModuleProvider, jComboBox, false);
                    keyEvent.consume();
                }
            }
        });
        jComboBox.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = jComboBox.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if (object == SEPARATOR_ITEM) {
                    int n = jComboBox.getSelectedIndex();
                    if (n > this.previousIndex) {
                        this.previousIndex = n + 1;
                        this.previousItem = jComboBox.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = n - 1;
                        this.previousItem = jComboBox.getItemAt(this.previousIndex);
                    }
                    jComboBox.setSelectedItem(this.previousItem);
                } else if ((actionEvent.getModifiers() & 0x10) != 0 && object == NEW_ITEM) {
                    DatasourceUIHelper.performCreateDatasource(j2eeModuleProvider, jComboBox, true);
                }
            }
        });
    }

    private static void performCreateDatasource(final J2eeModuleProvider j2eeModuleProvider, final JComboBox jComboBox, boolean bl) {
        Object object;
        final DatasourceComboBoxModel datasourceComboBoxModel = (DatasourceComboBoxModel)jComboBox.getModel();
        DatasourceCustomizer datasourceCustomizer = new DatasourceCustomizer(datasourceComboBoxModel.getDatasources());
        boolean bl2 = datasourceCustomizer.showDialog();
        ArrayList<ProgressSupport.BackgroundAction> arrayList = new ArrayList<ProgressSupport.BackgroundAction>();
        final Datasource[] datasourceArray = new Datasource[1];
        if (bl2) {
            object = datasourceCustomizer.getPassword();
            final String string = datasourceCustomizer.getJndiName();
            final String string2 = datasourceCustomizer.getUrl();
            final String string3 = datasourceCustomizer.getUsername();
            String string4 = datasourceCustomizer.getDriverClassName();
            arrayList.add(new ProgressSupport.BackgroundAction((String)object, string4){
                final /* synthetic */ String val$password;
                final /* synthetic */ String val$driverClassName;
                {
                    this.val$password = string4;
                    this.val$driverClassName = string5;
                }

                public void run(ProgressSupport.Context context) {
                    String string4 = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_creatingDS");
                    context.progress(string4);
                    try {
                        datasourceArray[0] = j2eeModuleProvider.createDatasource(string, string2, string3, this.val$password, this.val$driverClassName);
                    }
                    catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Datasource datasource : datasourceAlreadyExistsException.getDatasources()) {
                            stringBuilder.append(datasource.toString() + "\n");
                        }
                        String string22 = NbBundle.getMessage(DatasourceUIHelper.class, (String)"ERR_DsConflict", (Object)stringBuilder.toString());
                        Logger.getLogger("global").log(Level.INFO, string22, Exceptions.attachLocalizedMessage((Throwable)datasourceAlreadyExistsException, (String)string22));
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }

                public boolean isEnabled() {
                    return this.val$password != null;
                }
            });
        }
        object = new ArrayList();
        arrayList.add(new ProgressSupport.BackgroundAction((List)object, j2eeModuleProvider, datasourceArray){
            final /* synthetic */ List val$datasources;
            final /* synthetic */ J2eeModuleProvider val$provider;
            final /* synthetic */ Datasource[] val$ds;
            {
                this.val$datasources = list;
                this.val$provider = j2eeModuleProvider;
                this.val$ds = datasourceArray;
            }

            public void run(ProgressSupport.Context context) {
                String string = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                context.progress(string);
                try {
                    this.val$datasources.addAll(DatasourceUIHelper.getDatasources(this.val$provider));
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }

            public boolean isEnabled() {
                return this.val$ds[0] != null;
            }
        });
        ProgressSupport.invoke(arrayList);
        jComboBox.setPopupVisible(false);
        if (datasourceArray[0] == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DatasourceUIHelper.setSelectedItem(jComboBox, datasourceComboBoxModel.getPreviousItem());
                }
            });
        } else {
            DatasourceUIHelper.populate((List<Datasource>)object, j2eeModuleProvider.isDatasourceCreationSupported(), jComboBox, datasourceArray[0], bl);
        }
    }

    private static List<Datasource> getDatasources(J2eeModuleProvider j2eeModuleProvider) throws ConfigurationException {
        Set set = j2eeModuleProvider.getModuleDatasources();
        Set set2 = j2eeModuleProvider.getServerDatasources();
        int n = set.size() + set2.size();
        HashSet hashSet = new HashSet(n);
        hashSet.addAll(set);
        hashSet.addAll(set2);
        ArrayList<Datasource> arrayList = new ArrayList<Datasource>(hashSet);
        Collections.sort(arrayList, new DatasourceComparator());
        return arrayList;
    }

    private static List populate(List<Datasource> list, boolean bl, final JComboBox jComboBox, final Datasource datasource, boolean bl2) {
        LinkedList<Object> linkedList;
        LinkedList<Object> linkedList2 = linkedList = list == null ? new LinkedList<Object>() : new LinkedList<Datasource>(list);
        if (linkedList.size() > 0) {
            linkedList.add(SEPARATOR_ITEM);
        }
        if (bl) {
            linkedList.add(NEW_ITEM);
        }
        DatasourceComboBoxModel datasourceComboBoxModel = new DatasourceComboBoxModel(list, linkedList);
        jComboBox.setModel(datasourceComboBoxModel);
        if (datasource != null) {
            DatasourceUIHelper.setSelectedItem(jComboBox, datasource);
            if (bl2) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DatasourceUIHelper.setSelectedItem(jComboBox, datasource);
                    }
                });
            }
        }
        return list;
    }

    private static void setSelectedItem(JComboBox jComboBox, Object object) {
        jComboBox.setSelectedItem(object);
        if (jComboBox.isEditable() && jComboBox.getEditor() != null) {
            jComboBox.configureEditor(jComboBox.getEditor(), jComboBox.getSelectedItem());
        }
    }

    private static class DatasourceComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;
        private Object oldValue;

        DatasourceComboBoxEditor(ComboBoxEditor comboBoxEditor) {
            this.delegate = comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        public void setItem(Object object) {
            JTextComponent jTextComponent = this.getEditor();
            if (object != null) {
                String string = object instanceof Datasource ? ((Datasource)object).getJndiName() : object.toString();
                jTextComponent.setText(string);
                this.oldValue = object;
            } else {
                jTextComponent.setText("");
            }
        }

        public Object getItem() {
            JTextComponent jTextComponent = this.getEditor();
            Object object = jTextComponent.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    object = method.invoke(this.oldValue, jTextComponent.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void selectAll() {
            this.delegate.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }

        private JTextComponent getEditor() {
            Component component = this.getEditorComponent();
            assert (component instanceof JTextComponent);
            return (JTextComponent)component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatasourceComparator
    implements Comparator<Datasource> {
        private DatasourceComparator() {
        }

        @Override
        public int compare(Datasource datasource, Datasource datasource2) {
            if (datasource == null) {
                return datasource2 == null ? 0 : -1;
            }
            if (datasource2 == null) {
                return 1;
            }
            String string = datasource.getDisplayName();
            String string2 = datasource2.getDisplayName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareToIgnoreCase(string2);
        }
    }

    private static class DatasourceListCellRenderer
    extends DefaultListCellRenderer {
        private DatasourceListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof Datasource) {
                Datasource datasource = (Datasource)object;
                this.setText(datasource != null ? datasource.getDisplayName() : "");
                this.setToolTipText(datasource.toString());
            } else {
                if (object == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                this.setText(object != null ? object.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatasourceComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<Object> items;
        private Object selectedItem;
        private List<Datasource> datasources;
        private Object previousItem;

        private DatasourceComboBoxModel(List<Datasource> list, List<Object> list2) {
            this.datasources = list;
            this.items = list2;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedItem == null || !this.selectedItem.equals(object)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = object;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<Datasource> getDatasources() {
            return this.datasources;
        }

        public void addElement(Object object) {
            this.items.add(object);
        }

        @Override
        public void removeElement(Object object) {
            this.items.remove(object);
        }

        public void insertElementAt(Object object, int n) {
            this.items.set(n, object);
        }

        @Override
        public void removeElementAt(int n) {
            this.items.remove(n);
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }
}

