/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.AntArtifactChooser;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathUiSupport {
    private ClassPathUiSupport() {
    }

    public static DefaultListModel createListModel(Iterator iterator) {
        DefaultListModel defaultListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    public static Iterator<ClassPathSupport.Item> getIterator(DefaultListModel defaultListModel) {
        return ClassPathUiSupport.getList(defaultListModel).iterator();
    }

    public static List<ClassPathSupport.Item> getList(DefaultListModel defaultListModel) {
        return Collections.list(NbCollections.checkedEnumerationByFilter(defaultListModel.elements(), ClassPathSupport.Item.class, (boolean)true));
    }

    public static boolean canEdit(ListSelectionModel listSelectionModel, DefaultListModel defaultListModel) {
        boolean bl;
        boolean bl2 = bl = listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex() && listSelectionModel.getMinSelectionIndex() != -1;
        if (bl) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.get(listSelectionModel.getMinSelectionIndex());
            bl = item.canEdit();
        }
        return bl;
    }

    public static void edit(DefaultListModel defaultListModel, int[] nArray, AntProjectHelper antProjectHelper) {
        ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.getElementAt(nArray[0]);
        if (item.getType() == 0) {
            EditJarSupport.Item item2 = new EditJarSupport.Item();
            item2.setJarFile(item.getVariableBasedProperty() != null ? item.getVariableBasedProperty() : item.getFilePath());
            item2.setSourceFile(item.getSourceFilePath());
            item2.setJavadocFile(item.getJavadocFilePath());
            item2 = EditJarSupport.showEditDialog((AntProjectHelper)antProjectHelper, (EditJarSupport.Item)item2);
            if (item2 != null) {
                item.setJavadocFilePath(item2.getJavadocFile());
                item.setSourceFilePath(item2.getSourceFile());
            }
        }
        if (item.getType() == 1 && item.getLibrary() != null) {
            LibrariesCustomizer.showSingleLibraryCustomizer((Library)item.getLibrary());
        }
    }

    public static int[] moveUp(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "MoveUp button should be disabled";
        for (n = 0; n < nArray.length; ++n) {
            Object e = defaultListModel.get(nArray[n]);
            defaultListModel.remove(nArray[n]);
            defaultListModel.add(nArray[n] - 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    public static boolean canMoveUp(ListSelectionModel listSelectionModel) {
        return listSelectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "MoveDown button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            Object e = defaultListModel.get(nArray[n]);
            defaultListModel.remove(nArray[n]);
            defaultListModel.add(nArray[n] + 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    public static boolean canMoveDown(ListSelectionModel listSelectionModel, int n) {
        int n2 = listSelectionModel.getMaxSelectionIndex();
        return n2 != -1 && n2 < n - 1;
    }

    public static int[] remove(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "Remove button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            defaultListModel.remove(nArray[n]);
        }
        if (!defaultListModel.isEmpty()) {
            n = nArray[nArray.length - 1] - nArray.length + 1;
            if (n > defaultListModel.size() - 1) {
                n = defaultListModel.size() - 1;
            }
            return new int[]{n};
        }
        return new int[0];
    }

    public static int[] addLibraries(DefaultListModel defaultListModel, int[] nArray, Library[] libraryArray, Set<Library> set, Callback callback) {
        int n = nArray == null || nArray.length == 0 ? defaultListModel.getSize() - 1 : nArray[nArray.length - 1];
        int n2 = 1;
        for (int i = 0; i < libraryArray.length; ++i) {
            if (set.contains(libraryArray[i])) continue;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(libraryArray[i], null);
            if (callback != null) {
                callback.initItem(item);
            }
            defaultListModel.add(n + n2++, item);
        }
        HashSet<Library> hashSet = new HashSet<Library>(Arrays.asList(libraryArray));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.get(i);
            if (item.getType() != 1 || item.isBroken() || !hashSet.contains(item.getLibrary())) continue;
            arrayList.add(i);
        }
        int[] nArray2 = new int[arrayList.size()];
        int n3 = 0;
        for (Integer n4 : arrayList) {
            nArray2[n3++] = n4;
        }
        return nArray2;
    }

    public static int[] addJarFiles(DefaultListModel defaultListModel, int[] nArray, String[] stringArray, File file, String[] stringArray2, Callback callback) {
        int n = nArray == null || nArray.length == 0 ? defaultListModel.getSize() - 1 : nArray[nArray.length - 1];
        int[] nArray2 = new int[stringArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n2 + n3 < stringArray.length) {
            int n4 = n + 1 + n2;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(stringArray[n2], file, null, stringArray2 != null ? stringArray2[n2] : null);
            if (callback != null) {
                callback.initItem(item);
            }
            if (!defaultListModel.contains(item)) {
                defaultListModel.add(n4, item);
                nArray2[n3 + n2] = n4;
                ++n2;
                continue;
            }
            nArray2[n2 + n3] = defaultListModel.indexOf(item);
            ++n3;
        }
        return nArray2;
    }

    public static int[] addArtifacts(DefaultListModel defaultListModel, int[] nArray, AntArtifactChooser.ArtifactItem[] artifactItemArray, Callback callback) {
        int n = nArray == null || nArray.length == 0 ? defaultListModel.getSize() - 1 : nArray[nArray.length - 1];
        int[] nArray2 = new int[artifactItemArray.length];
        for (int i = 0; i < artifactItemArray.length; ++i) {
            int n2 = n + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItemArray[i].getArtifact(), artifactItemArray[i].getArtifactURI(), null);
            if (callback != null) {
                callback.initItem(item);
            }
            if (!defaultListModel.contains(item)) {
                defaultListModel.add(n2, item);
                nArray2[i] = n2;
                continue;
            }
            nArray2[i] = defaultListModel.indexOf(item);
        }
        return nArray2;
    }

    public static interface Callback {
        public void initItem(ClassPathSupport.Item var1);
    }
}

