/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ActionFilterNode;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesNode;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class J2eePlatformNode
extends AbstractNode
implements PropertyChangeListener,
InstanceListener {
    private static final String ARCHIVE_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif";
    private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif";
    private static final Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif"));
    private static final Image brokenIcon = Utilities.mergeImages((Image)Utilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif"), (Image)Utilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0);
    private final PropertyEvaluator evaluator;
    private final String platformPropName;
    private J2eePlatform platformCache;
    private final PropertyChangeListener platformListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                J2eePlatformNode.this.fireNameChange((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                J2eePlatformNode.this.fireDisplayNameChange((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
            }
            if ("classpath".equals(propertyChangeEvent.getPropertyName())) {
                J2eePlatformNode.this.postAddNotify();
            }
        }
    };
    private PropertyChangeListener weakPlatformListener;

    private J2eePlatformNode(Project project, PropertyEvaluator propertyEvaluator, String string, ClassPathSupport classPathSupport) {
        super((Children)new PlatformContentChildren(classPathSupport));
        this.evaluator = propertyEvaluator;
        this.platformPropName = string;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this, (Object)j2eeModuleProvider));
    }

    public static J2eePlatformNode create(Project project, PropertyEvaluator propertyEvaluator, String string, ClassPathSupport classPathSupport) {
        return new J2eePlatformNode(project, propertyEvaluator, string, classPathSupport);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "";
    }

    public String getHtmlDisplayName() {
        if (this.getPlatform() != null) {
            return this.getPlatform().getDisplayName();
        }
        return NbBundle.getMessage(J2eePlatformNode.class, (String)"LBL_J2eeServerMissing");
    }

    public Image getIcon(int n) {
        Image image = null;
        if (this.getPlatform() != null) {
            image = this.getPlatform().getIcon();
        }
        return image != null ? image : brokenIcon;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[0];
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.platformPropName.equals(propertyChangeEvent.getPropertyName())) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.platformCache != null) {
            this.platformCache.removePropertyChangeListener(this.weakPlatformListener);
        }
        this.platformCache = null;
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.postAddNotify();
    }

    public void instanceAdded(String string) {
        this.refresh();
    }

    public void instanceRemoved(String string) {
        this.refresh();
    }

    public void changeDefaultInstance(String string, String string2) {
    }

    private void postAddNotify() {
        LibrariesNode.rp.post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)J2eePlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    private J2eePlatform getPlatform() {
        if (this.platformCache == null) {
            String string = this.evaluator.getProperty(this.platformPropName);
            if (string != null) {
                this.platformCache = Deployment.getDefault().getJ2eePlatform(string);
            }
            if (this.platformCache != null) {
                this.weakPlatformListener = WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)this.platformCache);
                this.platformCache.addPropertyChangeListener(this.weakPlatformListener);
                this.fireIconChange();
            }
        }
        return this.platformCache;
    }

    private static class PlatformContentChildren
    extends Children.Keys {
        private ClassPathSupport cs;

        PlatformContentChildren(ClassPathSupport classPathSupport) {
            this.cs = classPathSupport;
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            SourceGroup sourceGroup = (SourceGroup)object;
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sourceGroup), null, null, null, null, null, null)};
        }

        private List getKeys() {
            ArrayList<LibrariesSourceGroup> arrayList;
            J2eePlatform j2eePlatform = ((J2eePlatformNode)this.getNode()).getPlatform();
            if (j2eePlatform != null) {
                File[] fileArray = j2eePlatform.getClasspathEntries();
                arrayList = new ArrayList<LibrariesSourceGroup>(fileArray.length);
                for (int i = 0; i < fileArray.length; ++i) {
                    FileObject fileObject;
                    FileObject fileObject2 = FileUtil.toFileObject((File)fileArray[i]);
                    if (fileObject2 == null || (fileObject = FileUtil.getArchiveRoot((FileObject)fileObject2)) == null) continue;
                    arrayList.add(new LibrariesSourceGroup(fileObject, fileObject2.getNameExt(), icon, icon));
                }
            } else {
                arrayList = Collections.EMPTY_LIST;
            }
            return arrayList;
        }
    }
}

