/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ActionFilterNode;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesNode;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.j2ee.common.project.ui.ShowJavadocAction;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider platformProvider, ClassPathSupport classPathSupport) {
        super((Children)new PlatformContentChildren(classPathSupport), Lookups.singleton((Object)new JavadocProvider(platformProvider)));
        this.pp = platformProvider;
        this.pp.addChangeListener(this);
        this.setIconBaseWithExtension(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String string;
        JavaPlatform javaPlatform = this.pp.getPlatform();
        String string2 = javaPlatform != null ? javaPlatform.getDisplayName() : ((string = this.pp.getPlatformId()) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), string));
        return string2;
    }

    public String getHtmlDisplayName() {
        if (this.pp.getPlatform() == null) {
            String string = this.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            return "<font color=\"#A40000\">" + string + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class)};
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        LibrariesNode.rp.post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    static PlatformNode create(PropertyEvaluator propertyEvaluator, String string, ClassPathSupport classPathSupport) {
        PlatformProvider platformProvider = new PlatformProvider(propertyEvaluator, string);
        return new PlatformNode(platformProvider, classPathSupport);
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        public boolean hasJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform == null) {
                return false;
            }
            URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
            return uRLArray.length > 0;
        }

        public void showJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform != null) {
                URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
                URL uRL = ShowJavadocAction.findJavadoc("/overview-summary.html", uRLArray);
                if (uRL == null) {
                    uRL = ShowJavadocAction.findJavadoc("/index.html", uRLArray);
                }
                ShowJavadocAction.showJavaDoc(uRL, javaPlatform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform javaPlatform) {
            HashSet<URL> hashSet = new HashSet<URL>();
            List list = javaPlatform.getBootstrapLibraries().entries();
            for (ClassPath.Entry entry : list) {
                hashSet.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)entry.getURL()).getRoots()));
            }
            return hashSet.toArray(new URL[hashSet.size()]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private JavaPlatform platformCache;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(PropertyEvaluator propertyEvaluator, String string) {
            this.evaluator = propertyEvaluator;
            this.platformPropName = string;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        public String getPlatformId() {
            return this.evaluator.getProperty(this.platformPropName);
        }

        public JavaPlatform getPlatform() {
            if (this.platformCache == null) {
                String string = this.getPlatformId();
                if (string == null) {
                    this.platformCache = JavaPlatformManager.getDefault().getDefaultPlatform();
                } else {
                    JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < javaPlatformArray.length; ++i) {
                        if (!string.equals(javaPlatformArray[i].getProperties().get("platform.ant.name"))) continue;
                        if (javaPlatformArray[i].getInstallFolders().size() <= 0) break;
                        this.platformCache = javaPlatformArray[i];
                        break;
                    }
                }
            }
            return this.platformCache;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.platformPropName.equals(propertyChangeEvent.getPropertyName())) {
                this.platformCache = null;
                this.changeSupport.fireChange();
            }
        }
    }

    private static class PlatformContentChildren
    extends Children.Keys {
        private ClassPathSupport cs;

        PlatformContentChildren(ClassPathSupport classPathSupport) {
            this.cs = classPathSupport;
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            SourceGroup sourceGroup = (SourceGroup)object;
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sourceGroup), null, null, null, null, null, null)};
        }

        private List getKeys() {
            JavaPlatform javaPlatform = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (javaPlatform == null) {
                return Collections.EMPTY_LIST;
            }
            FileObject[] fileObjectArray = javaPlatform.getBootstrapLibraries().getRoots();
            ArrayList<LibrariesSourceGroup> arrayList = new ArrayList<LibrariesSourceGroup>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    ImageIcon imageIcon;
                    ImageIcon imageIcon2;
                    FileObject fileObject;
                    if ("jar".equals(fileObjectArray[i].getURL().getProtocol())) {
                        fileObject = FileUtil.getArchiveFile((FileObject)fileObjectArray[i]);
                        imageIcon = imageIcon2 = new ImageIcon(Utilities.loadImage((String)PlatformNode.ARCHIVE_ICON));
                    } else {
                        fileObject = fileObjectArray[i];
                        imageIcon = null;
                        imageIcon2 = null;
                    }
                    if (!fileObject.isValid()) continue;
                    arrayList.add(new LibrariesSourceGroup(fileObjectArray[i], fileObject.getNameExt(), imageIcon, imageIcon2));
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            return arrayList;
        }
    }
}

