/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.AbstractMapperEventHandler;
import org.netbeans.modules.soa.mappercore.AutoSelectionCanvas;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasSearchResult;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPopupMenuFactory;
import org.netbeans.modules.soa.mappercore.MoveTool;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Function;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class CanvasEventHandler
extends AbstractMapperEventHandler {
    private MouseEvent initialEvent = null;
    private Vertex resizingVertex = null;

    public CanvasEventHandler(Canvas canvas) {
        super(canvas.getMapper(), canvas);
        new AutoSelectionCanvas(canvas);
    }

    private void reset() {
        this.initialEvent = null;
        this.resizingVertex = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        CanvasSearchResult canvasSearchResult = this.getCanvas().find(mouseEvent.getX(), mouseEvent.getY());
        if (canvasSearchResult != null) {
            SelectionModel selectionModel = this.getSelectionModel();
            if (mouseEvent.isControlDown()) {
                selectionModel.switchSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem());
            } else if (selectionModel.isSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem())) {
                selectionModel.setSelected(canvasSearchResult.getTreePath(), canvasSearchResult.getGraphItem());
            }
        }
        this.reset();
        if (mouseEvent.isPopupTrigger() && this.getMapper().getNodeAt(mouseEvent.getY()) != null) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.reset();
        Canvas canvas = this.getCanvas();
        if (!canvas.hasFocus()) {
            canvas.requestFocusInWindow();
        }
        SelectionModel selectionModel = this.getSelectionModel();
        int n = mouseEvent.getY();
        int n2 = mouseEvent.getX();
        CanvasSearchResult canvasSearchResult = this.getCanvas().find(n2, n);
        if (canvasSearchResult != null) {
            TreePath treePath = canvasSearchResult.getTreePath();
            GraphItem graphItem = canvasSearchResult.getGraphItem();
            if (graphItem != null) {
                if (!mouseEvent.isControlDown() && !selectionModel.isSelected(treePath, graphItem)) {
                    selectionModel.setSelected(treePath, graphItem);
                }
            } else if (!mouseEvent.isControlDown()) {
                selectionModel.setSelected(treePath);
            }
        }
        this.initialEvent = mouseEvent;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        if (this.initialEvent != null && this.resizingVertex == null) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            object3 = this.getCanvas().find(n2, n);
            if (object3 != null) {
                object2 = ((CanvasSearchResult)object3).getGraphItem();
                object = null;
                if (object2 instanceof Function) {
                    object = ((Function)object2).getBounds();
                }
                if (object2 instanceof VertexItem && ((VertexItem)object2).getVertex() instanceof Constant) {
                    object = ((VertexItem)object2).getVertex().getBounds();
                }
                if (object != null) {
                    int n3 = ((Rectangle)object).x + ((Rectangle)object).width;
                    int n4 = ((Rectangle)object).y + ((Rectangle)object).height;
                    int n5 = this.getCanvas().getStep();
                    int n6 = this.getCanvas().toGraphY(n);
                    n6 = n6 + (n5 - 1) / 2 + 1;
                    n3 = this.getCanvas().toCanvas(n3 * n5);
                    n4 = n4 * n5 + n6;
                    int n7 = n3 - n2;
                    int n8 = n4 - n;
                    if (n7 > 0 && n8 > 0 && n7 + n8 < n5) {
                        this.resizingVertex = object2 instanceof Vertex ? (Vertex)object2 : ((VertexItem)object2).getVertex();
                    }
                }
            }
        }
        if (this.resizingVertex != null) {
            n2 = this.getCanvas().getStep();
            n = this.getCanvas().toGraph(mouseEvent.getX()) / n2;
            int n9 = this.resizingVertex.getX();
            this.resizingVertex.setWidth(n - n9);
            this.getCanvas().repaint();
            return;
        }
        if (this.initialEvent != null && this.initialEvent.getPoint().distance(mouseEvent.getPoint()) >= 5.0) {
            LinkTool linkTool = this.getMapper().getLinkTool();
            MoveTool moveTool = this.getMapper().getMoveTool();
            object3 = null;
            object2 = this.getCanvas().find(this.initialEvent.getX(), this.initialEvent.getY());
            if (object2 == null) {
                this.reset();
                return;
            }
            if (((CanvasSearchResult)object2).getPinItem() instanceof Vertex) {
                object = (Vertex)((CanvasSearchResult)object2).getPinItem();
                Link link = ((Vertex)object).getOutgoingLink();
                if (link == null) {
                    object3 = linkTool.activateOutgoing(((CanvasSearchResult)object2).getTreePath(), (Vertex)object);
                } else {
                    TargetPin targetPin = link.getTarget();
                    if (targetPin instanceof VertexItem) {
                        object3 = linkTool.activateIngoing(((CanvasSearchResult)object2).getTreePath(), (VertexItem)targetPin);
                    } else if (targetPin instanceof Graph) {
                        object3 = linkTool.activateIngoing(((CanvasSearchResult)object2).getTreePath(), (Graph)targetPin, link);
                    }
                }
            } else if (((CanvasSearchResult)object2).getPinItem() instanceof VertexItem) {
                object = (VertexItem)((CanvasSearchResult)object2).getPinItem();
                Link link = ((VertexItem)object).getIngoingLink();
                if (link == null) {
                    object3 = linkTool.activateIngoing(((CanvasSearchResult)object2).getTreePath(), (VertexItem)((CanvasSearchResult)object2).getPinItem());
                } else {
                    SourcePin sourcePin = link.getSource();
                    if (sourcePin instanceof Vertex) {
                        object3 = linkTool.activateOutgoing(((CanvasSearchResult)object2).getTreePath(), (Vertex)sourcePin);
                    } else if (sourcePin instanceof TreeSourcePin) {
                        object3 = linkTool.activateOutgoing((TreeSourcePin)sourcePin, link, ((CanvasSearchResult)object2).getTreePath());
                    }
                }
            } else if (((CanvasSearchResult)object2).getGraphItem() instanceof Vertex) {
                object3 = moveTool.getMoveTransferable(this.getSelectionModel().getSelectedSubset(), this.initialEvent.getPoint());
            }
            if (object3 != null) {
                this.startDrag(this.initialEvent, (Transferable)object3, 2);
            }
            this.reset();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        CanvasSearchResult canvasSearchResult = this.getCanvas().find(n, n2);
        if (canvasSearchResult != null) {
            GraphItem graphItem = canvasSearchResult.getGraphItem();
            Rectangle rectangle = null;
            if (graphItem instanceof Function) {
                rectangle = ((Function)graphItem).getBounds();
            }
            if (graphItem instanceof VertexItem && ((VertexItem)graphItem).getVertex() instanceof Constant) {
                rectangle = ((VertexItem)graphItem).getVertex().getBounds();
            }
            if (rectangle != null) {
                int n3 = rectangle.x + rectangle.width;
                int n4 = rectangle.y + rectangle.height;
                int n5 = this.getCanvas().getStep();
                int n6 = this.getCanvas().toGraphY(n2);
                n6 = n6 + (n5 - 1) / 2 + 1;
                n3 = this.getCanvas().toCanvas(n3 * n5);
                n4 = n4 * n5 + n6;
                int n7 = n3 - n;
                int n8 = n4 - n2;
                if (n7 > 0 && n8 > 0 && n7 + n8 < n5) {
                    this.getCanvas().setCursor(new Cursor(10));
                    return;
                }
            }
            this.getCanvas().setCursor(null);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Mapper mapper;
            MapperNode mapperNode;
            GraphItem graphItem;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            CanvasSearchResult canvasSearchResult = this.getCanvas().find(n, n2);
            GraphItem graphItem2 = graphItem = canvasSearchResult == null ? null : canvasSearchResult.getGraphItem();
            if (graphItem instanceof VertexItem) {
                this.getCanvas().startEdit(canvasSearchResult.getTreePath(), (VertexItem)graphItem);
            }
            if ((mapperNode = (mapper = this.getMapper()).getNodeAt(n2)) != null && mapperNode.getGraph() != null && !mapperNode.getGraph().isEmptyOrOneLink()) {
                if (graphItem == null) {
                    mapper.setExpandedGraphState(mapperNode.getTreePath(), mapperNode.isGraphCollapsed());
                }
                this.getLinkTool().done();
            }
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        List<Vertex> list;
        MapperContext mapperContext = this.getMapper().getContext();
        MapperModel mapperModel = this.getMapper().getModel();
        if (mapperContext == null || mapperModel == null) {
            return;
        }
        TreePath treePath = this.getSelectionModel().getSelectedPath();
        if (treePath == null) {
            return;
        }
        GraphItem graphItem = null;
        List<Link> list2 = this.getSelectionModel().getSelectedLinks();
        if (list2 != null && !list2.isEmpty()) {
            graphItem = list2.get(0);
        }
        if ((list = this.getSelectionModel().getSelectedVerteces()) != null && !list.isEmpty()) {
            graphItem = list.get(0);
        }
        JPopupMenu jPopupMenu = MapperPopupMenuFactory.createMapperPopupMenu(this.getCanvas(), graphItem);
        List<JMenu> list3 = mapperContext.getMenuNewEllements(mapperModel);
        JMenu jMenu = (JMenu)jPopupMenu.getComponent(0);
        for (JMenu jMenu2 : list3) {
            jMenu.add(jMenu2);
        }
        JPopupMenu jPopupMenu2 = mapperContext.getCanvasPopupMenu(mapperModel, graphItem);
        if (jPopupMenu2 != null) {
            if (jPopupMenu2.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            for (int i = 0; i < jPopupMenu2.getComponentCount(); ++i) {
                jPopupMenu.add(jPopupMenu2.getComponent(i));
            }
        }
        if (jPopupMenu != null) {
            jPopupMenu.show(this.getCanvas(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

