/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.FilteredTreeModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMapperModel
extends FilteredTreeModel
implements MapperModel {
    private MapperModel mapperModel;
    private FilteredTreeModel filteredLeftTreeModel;
    private Set<Graph> nonEmptyGraphsSet = new HashSet<Graph>();
    private Map<TreePath, Graph> nonEmptyGraphsMap = new HashMap<TreePath, Graph>();
    private Map<Object, Set<Object>> leftAcceptedChildren = new HashMap<Object, Set<Object>>();
    private Map<Object, Set<Object>> rightAcceptedChildren = new HashMap<Object, Set<Object>>();
    private boolean filterLeft;
    private boolean filterRight;

    public FilteredMapperModel(MapperModel mapperModel, boolean bl, boolean bl2) {
        super(mapperModel, bl2);
        this.filterLeft = bl;
        this.filterRight = bl2;
        this.mapperModel = mapperModel;
        Object object = mapperModel.getRoot();
        if (object != null) {
            this.collectGraphs(mapperModel, new TreePath(object), this.nonEmptyGraphsMap, this.nonEmptyGraphsSet);
        }
        if (bl) {
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            this.collectTreeSourcePinPathes(this.nonEmptyGraphsSet, hashSet);
            this.fillAcceptedChildrenMap(hashSet, this.leftAcceptedChildren);
            this.filteredLeftTreeModel = new FilteredTreeModel(mapperModel.getLeftTreeModel(), true){

                protected boolean accept(Object object, Object object2) {
                    Set set = (Set)FilteredMapperModel.this.leftAcceptedChildren.get(object);
                    return set != null && set.contains(object2);
                }
            };
        }
        if (bl2) {
            this.fillAcceptedChildrenMap(this.nonEmptyGraphsMap.keySet(), this.rightAcceptedChildren);
        }
    }

    public boolean isFilterLeft() {
        return this.filterLeft;
    }

    public boolean isFilterRight() {
        return this.filterRight;
    }

    public MapperModel getOriginalMapperModel() {
        return this.mapperModel;
    }

    @Override
    protected boolean accept(Object object, Object object2) {
        Set<Object> set = this.rightAcceptedChildren.get(object);
        return set != null && set.contains(object2);
    }

    @Override
    public TreeModel getLeftTreeModel() {
        return this.filterLeft ? this.filteredLeftTreeModel : this.mapperModel.getLeftTreeModel();
    }

    @Override
    public TreeSourcePin getTreeSourcePin(TreePath treePath) {
        return this.mapperModel.getTreeSourcePin(treePath);
    }

    @Override
    public Graph getGraph(TreePath treePath) {
        return this.mapperModel.getGraph(treePath);
    }

    @Override
    public boolean searchGraphsInside(TreePath treePath) {
        return this.mapperModel.searchGraphsInside(treePath);
    }

    @Override
    public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        return this.mapperModel.canConnect(treePath, sourcePin, targetPin, treePath2, link);
    }

    @Override
    public void connect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        this.mapperModel.connect(treePath, sourcePin, targetPin, treePath2, link);
    }

    @Override
    public GraphSubset getGraphSubset(Transferable transferable) {
        return this.mapperModel.getGraphSubset(transferable);
    }

    @Override
    public boolean canCopy(TreePath treePath, GraphSubset graphSubset) {
        return this.mapperModel.canCopy(treePath, graphSubset);
    }

    @Override
    public boolean canMove(TreePath treePath, GraphSubset graphSubset) {
        return this.mapperModel.canMove(treePath, graphSubset);
    }

    @Override
    public GraphSubset copy(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        return this.mapperModel.copy(treePath, graphSubset, n, n2);
    }

    @Override
    public void move(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        this.mapperModel.move(treePath, graphSubset, n, n2);
    }

    @Override
    public void valueChanged(TreePath treePath, VertexItem vertexItem, Object object) {
        this.mapperModel.valueChanged(treePath, vertexItem, object);
    }

    @Override
    public boolean canEditInplace(VertexItem vertexItem) {
        return this.mapperModel.canEditInplace(vertexItem);
    }

    @Override
    public void delete(TreePath treePath, GraphSubset graphSubset) {
        this.mapperModel.delete(treePath, graphSubset);
    }

    private void collectGraphs(MapperModel mapperModel, TreePath treePath, Map<TreePath, Graph> map, Set<Graph> set) {
        Object object;
        Graph graph = mapperModel.getGraph(treePath);
        if (graph != null && !graph.isEmpty()) {
            map.put(treePath, graph);
            set.add(graph);
        }
        if (mapperModel.isLeaf(object = treePath.getLastPathComponent())) {
            return;
        }
        if (!mapperModel.searchGraphsInside(treePath)) {
            return;
        }
        int n = mapperModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = mapperModel.getChild(object, i);
            this.collectGraphs(mapperModel, treePath.pathByAddingChild(object2), map, set);
        }
    }

    private void collectTreeSourcePinPathes(Set<Graph> set, Set<TreePath> set2) {
        for (Graph graph : set) {
            List<Link> list = graph.getIngoingLinks();
            if (list == null) continue;
            for (Link link : list) {
                TreePath treePath;
                SourcePin sourcePin = link.getSource();
                if (!(sourcePin instanceof TreeSourcePin) || (treePath = ((TreeSourcePin)sourcePin).getTreePath()) == null) continue;
                set2.add(treePath);
            }
        }
    }

    private void fillAcceptedChildrenMap(Set<TreePath> set, Map<Object, Set<Object>> map) {
        for (TreePath treePath : set) {
            TreePath treePath2 = treePath.getParentPath();
            Object object = treePath.getLastPathComponent();
            while (treePath2 != null) {
                Object object2 = treePath2.getLastPathComponent();
                Set<Object> set2 = map.get(object2);
                if (set2 == null) {
                    set2 = new HashSet<Object>();
                    map.put(object2, set2);
                }
                set2.add(object);
                treePath = treePath2;
                treePath2 = treePath.getParentPath();
                object = object2;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.filteredLeftTreeModel != null) {
            this.filteredLeftTreeModel.dispose();
        }
    }
}

