/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.DefaultLeftTreeCellRenderer;
import org.netbeans.modules.soa.mappercore.LeftTreeEventHandler;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.ViewTooltips;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.search.Navigation;
import org.netbeans.modules.soa.mappercore.utils.ScrollPaneWrapper;
import org.netbeans.modules.soa.mappercore.utils.Utils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftTree
extends JTree
implements AdjustmentListener,
TreeExpansionListener,
Autoscroll {
    private Mapper mapper;
    private LeftTreeEventHandler eventHandler;
    public JComponent scrollPaneWrapper;
    public JScrollPane scrollPane;
    private static final int EDGE_CONNECTED = 1;
    private static final int EDGE_CONNECTED_TO_CHILD = 2;

    public LeftTree(Mapper mapper) {
        super((TreeModel)null);
        this.mapper = mapper;
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.order", new Integer(0));
        this.scrollPane = new JScrollPane(this, 20, 32);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollPaneWrapper = new Navigation(this, this.scrollPane, new ScrollPaneWrapper(this.scrollPane));
        this.addTreeExpansionListener(this);
        this.setCellRenderer(new DefaultLeftTreeCellRenderer(mapper));
        this.eventHandler = new LeftTreeEventHandler(this);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Object object = mouseEvent.getSource();
                    assert (object instanceof JTree);
                    TreePath treePath = ((JTree)object).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        Object object2 = treePath.getLastPathComponent();
                        JPopupMenu jPopupMenu = LeftTree.this.mapper.getContext().getLeftPopupMenu(LeftTree.this.mapper.getModel(), object2);
                        if (jPopupMenu != null) {
                            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        ToolTipManager.sharedInstance().registerComponent(this);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "press-right-control");
        actionMap.put("press-right-control", new RightControlAction());
        inputMap.put(KeyStroke.getKeyStroke(121, 64), "show-popupMenu");
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "show-popupMenu");
        actionMap.put("show-popupMenu", new ShowPopupMenuAction());
        ViewTooltips.register(this);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LeftTree.class, (String)"ACSN_LeftTree"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LeftTree.class, (String)"ACSD_LeftTree"));
    }

    public void registrAction(MapperKeyboardAction mapperKeyboardAction) {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        String string = mapperKeyboardAction.getActionKey();
        actionMap.put(string, mapperKeyboardAction);
        KeyStroke[] keyStrokeArray = mapperKeyboardAction.getShortcuts();
        if (keyStrokeArray != null) {
            for (KeyStroke keyStroke : keyStrokeArray) {
                inputMap.put(keyStroke, string);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        MapperModel mapperModel = this.getMapper().getModel();
        MapperContext mapperContext = this.getMapper().getContext();
        if (mapperModel == null || mapperContext == null) {
            return null;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return null;
        }
        return mapperContext.getLeftToolTipText(mapperModel, object);
    }

    public int yToMapper(int n) {
        for (Container container = this; container != this.mapper; container = container.getParent()) {
            n += ((Component)container).getY();
        }
        return n;
    }

    public int yFromMapper(int n) {
        for (Container container = this; container != this.mapper; container = container.getParent()) {
            n -= ((Component)container).getY();
        }
        return n;
    }

    public int getCenterY(TreePath treePath) {
        Rectangle rectangle = this.getRowBounds(this.getRowForPath(treePath));
        while (rectangle == null) {
            treePath = treePath.getParentPath();
            rectangle = this.getRowBounds(this.getRowForPath(treePath));
        }
        return rectangle.y + rectangle.height / 2;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JComponent getView() {
        return this.scrollPaneWrapper;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    MapperNode getRoot() {
        return this.mapper.getRoot();
    }

    MapperModel getMapperModel() {
        return this.mapper.getFilteredModel();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += this.mapper.getStepSize();
        return dimension;
    }

    @Override
    protected void printComponent(Graphics graphics) {
        this.mapper.setPrintMode(true);
        super.printComponent(graphics);
        this.mapper.setPrintMode(false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Map<TreePath, Set<Link>> map = this.getConnectedTreePathes();
        if (!map.isEmpty()) {
            TreePath treePath2;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Object[][] objectArray = new Object[map.size()][];
            int n = this.getWidth() - 1;
            int n2 = 0;
            for (TreePath treePath2 : map.keySet()) {
                objectArray[n2++] = treePath2.getPath();
            }
            SelectionModel selectionModel = this.getMapper().getSelectionModel();
            treePath2 = selectionModel.getSelectedPath();
            int n3 = this.getRowCount();
            for (int i = 0; i < n3; ++i) {
                Set<Link> set = this.connectedEdges(i, this.getPathForRow(i), map, objectArray);
                if (set == null || set.size() <= 0) continue;
                Rectangle rectangle = this.getRowBounds(i);
                int n4 = rectangle.x + rectangle.width;
                int n5 = rectangle.y + rectangle.height / 2;
                Set<Link> set2 = map.get(this.getPathForRow(i));
                Color color = MapperStyle.LINK_COLOR_UNSELECTED_NODE;
                boolean bl = false;
                if (!this.mapper.getPrintMode()) {
                    for (Link link : set) {
                        if (selectionModel.isSelected(treePath2, link) && this.mapper.getNode(treePath2, true).isVisibleGraph()) {
                            color = MapperStyle.SELECTION_COLOR;
                            bl = true;
                            break;
                        }
                        if (color == MapperStyle.LINK_COLOR_SELECTED_NODE || selectionModel.getSelectedGraph() != link.getGraph() && !this.parentPathIsSelected(this.mapper.getRightTreePathForLink(link).getParentPath())) continue;
                        color = MapperStyle.LINK_COLOR_SELECTED_NODE;
                        color = MapperStyle.LINK_COLOR_SELECTED_NODE;
                    }
                }
                graphics2D.setPaint(color);
                Stroke stroke = graphics2D.getStroke();
                if (set2 == null || set.size() > set2.size()) {
                    if (bl) {
                        graphics2D.setStroke(Mapper.DASHED_SELECTED_STROKE);
                    } else {
                        graphics2D.setStroke(Mapper.DASHED_STROKE);
                    }
                    graphics2D.drawLine(n4, n5, n, n5);
                } else {
                    if (bl) {
                        graphics2D.setStroke(MapperStyle.SELECTION_STROKE);
                    }
                    graphics2D.drawLine(n4, n5, n, n5);
                }
                graphics2D.setStroke(stroke);
            }
            graphics2D.dispose();
        }
        this.getMapper().getLinkTool().paintLeftTree(this, graphics);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        super.repaint(l, n, n2, n3, n4);
        if (this.mapper == null) {
            return;
        }
        Canvas canvas = this.mapper.getCanvas();
        if (canvas == null) {
            return;
        }
        canvas.repaint();
    }

    @Override
    public int getY() {
        if (this.getMapper().getPrintMode()) {
            return 0;
        }
        return super.getY();
    }

    private Set<Link> connectedEdges(int n, TreePath treePath, Map<TreePath, Set<Link>> map, Object[][] objectArray) {
        if (this.getModel().isLeaf(treePath.getLastPathComponent()) || this.isExpanded(n)) {
            return map.get(treePath);
        }
        HashSet<Link> hashSet = new HashSet<Link>();
        if (map.get(treePath) != null) {
            hashSet.addAll((Collection)map.get(treePath));
        }
        for (TreePath treePath2 : map.keySet()) {
            if (!treePath.isDescendant(treePath2)) continue;
            hashSet.addAll((Collection<Link>)map.get(treePath2));
        }
        return hashSet;
    }

    private boolean parentPathIsSelected(TreePath treePath) {
        if (treePath.getParentPath() == null) {
            return false;
        }
        MapperNode mapperNode = this.mapper.getNode(treePath, true);
        if (mapperNode.isExpanded()) {
            return false;
        }
        if (mapperNode.isSelected()) {
            return true;
        }
        return this.parentPathIsSelected(treePath.getParentPath());
    }

    private boolean pathStartsWith(Object[] objectArray, TreePath treePath, int n) {
        int n2 = objectArray.length;
        if (n2 < n) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (treePath.getLastPathComponent() != objectArray[i]) {
                return false;
            }
            treePath = treePath.getParentPath();
        }
        return true;
    }

    public Map<TreePath, Set<Link>> getConnectedTreePathes() {
        MapperNode mapperNode = this.getRoot();
        MapperModel mapperModel = this.getMapperModel();
        HashMap<TreePath, Set<Link>> hashMap = new HashMap<TreePath, Set<Link>>();
        if (mapperNode != null && mapperModel != null) {
            Set<Graph> set = this.getRoot().getChildGraphs();
            Graph graph = this.getRoot().getGraph();
            if (graph != null) {
                set.add(graph);
            }
            if (set != null) {
                ArrayList<Link> arrayList = new ArrayList<Link>();
                for (Graph graph2 : set) {
                    graph2.getIngoingLinks(arrayList);
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Link link = (Link)arrayList.get(i);
                        TreePath treePath = ((TreeSourcePin)link.getSource()).getTreePath();
                        HashSet<Link> hashSet = (HashSet<Link>)hashMap.get(treePath);
                        if (hashSet != null) {
                            ((Set)hashMap.get(treePath)).add(link);
                            continue;
                        }
                        hashSet = new HashSet<Link>();
                        hashSet.add(link);
                        hashMap.put(treePath, hashSet);
                    }
                    arrayList.clear();
                }
            }
        }
        return hashMap;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.mapper.getCanvas().repaint();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.mapper.getCanvas().repaint();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.mapper.getCanvas().repaint();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        MapperContext mapperContext = this.mapper.getContext();
        MapperModel mapperModel = this.mapper.getModel();
        if (object == null || mapperContext == null || mapperModel == null) {
            return super.convertValueToText(object, bl, bl2, bl3, n, bl4);
        }
        return mapperContext.getLeftDysplayText(mapperModel, object);
    }

    public Link getOutgoingLinkForPath(TreePath treePath) {
        MapperNode mapperNode = this.getRoot();
        MapperModel mapperModel = this.getMapperModel();
        Link link = null;
        if (mapperNode != null && mapperModel != null) {
            Set<Graph> set = this.getRoot().getChildGraphs();
            Graph graph = this.getRoot().getGraph();
            if (graph != null) {
                set.add(graph);
            }
            if (set != null) {
                List<Object> list = new ArrayList();
                for (Graph graph2 : set) {
                    list = graph2.getIngoingLinks();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        link = (Link)list.get(i);
                        if (!Utils.equal(treePath, ((TreeSourcePin)link.getSource()).getTreePath())) continue;
                        return link;
                    }
                    list.clear();
                }
            }
        }
        return null;
    }

    public List<Link> getOutgoingLinksForRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        return this.getAllOutgoingLinksForTreePath(treePath);
    }

    private List<Link> getAllOutgoingLinksForTreePath(TreePath treePath) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        arrayList.add(this.getOutgoingLinkForPath(treePath));
        TreeModel treeModel = this.getModel();
        int n = 0;
        while (n < treeModel.getChildCount(treePath)) {
            TreePath treePath2 = (TreePath)treeModel.getChild(treePath, n);
            if (!treeModel.isLeaf(treePath2)) {
                arrayList.addAll(this.getAllOutgoingLinksForTreePath(treePath2));
                continue;
            }
            arrayList.add(this.getOutgoingLinkForPath(treePath2));
        }
        return arrayList;
    }

    public int getParentsRowForPath(TreePath treePath) {
        int n = this.getRowForPath(treePath);
        if (n > -1) {
            return n;
        }
        return this.getParentsRowForPath(treePath.getParentPath());
    }

    public TreePath getParentVisiblePathForPath(TreePath treePath) {
        return this.getPathForRow(this.getParentsRowForPath(treePath));
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return new Insets(rectangle.y + 16, rectangle.x + 16, this.getHeight() - rectangle.y - rectangle.height + 16, this.getWidth() - rectangle.x - rectangle.width + 16);
    }

    @Override
    public void autoscroll(Point point) {
        if (this.scrollPane.getViewport() == null) {
            return;
        }
        Insets insets = this.getAutoscrollInsets();
        Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
        if (point.y > this.getHeight() - insets.bottom) {
            rectangle.y = this.getHeight() - insets.bottom + 16 + 2 * this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.y < insets.top) {
            rectangle.y = insets.top - 16 - 2 * this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.x > this.getWidth() - insets.right) {
            rectangle.x = this.getWidth() - insets.right + 16 + 2 * this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        if (point.x < insets.left) {
            rectangle.x = insets.left - 16 - 2 * this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        this.scrollRectToVisible(rectangle);
    }

    private class ShowPopupMenuAction
    extends AbstractAction {
        private ShowPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LeftTree leftTree = LeftTree.this;
            TreePath treePath = leftTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            int n = leftTree.getRowForPath(treePath);
            if (n < 0) {
                return;
            }
            Rectangle rectangle = leftTree.getRowBounds(n);
            Object object = treePath.getLastPathComponent();
            if (object == null) {
                return;
            }
            JPopupMenu jPopupMenu = leftTree.mapper.getContext().getLeftPopupMenu(leftTree.mapper.getModel(), object);
            if (jPopupMenu != null) {
                jPopupMenu.show(leftTree, rectangle.x, rectangle.y);
            }
        }
    }

    private class RightControlAction
    extends AbstractAction {
        private RightControlAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mapper mapper = LeftTree.this.getMapper();
            TreePath treePath = LeftTree.this.getSelectionPath();
            mapper.getCanvas().requestFocusInWindow();
            Link link = LeftTree.this.getOutgoingLinkForPath(treePath);
            if (link == null) {
                return;
            }
            treePath = mapper.getRightTreePathForLink(link);
            mapper.getSelectionModel().setSelected(treePath, link);
        }
    }
}

